/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.template.TemplateProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class TemplateManager
implements ServiceTrackerCustomizer {
    private ServiceTracker templateProviderTracker;
    private RuleEngine ruleEngine;
    private BundleContext bc;
    private Collection<TemplateProvider> providers = new HashSet<TemplateProvider>();

    public TemplateManager(BundleContext bc, RuleEngine re) {
        this.bc = bc;
        this.ruleEngine = re;
        this.templateProviderTracker = new ServiceTracker(bc, TemplateProvider.class.getName(), (ServiceTrackerCustomizer)this);
        this.templateProviderTracker.open();
    }

    public <T extends Template> T get(String templateUID) {
        return this.get(templateUID, null);
    }

    public <T extends Template> T get(String templateUID, Locale locale) {
        Template template = null;
        for (TemplateProvider templateProvider : this.providers) {
            template = templateProvider.getTemplate(templateUID, locale);
            if (template == null) continue;
            return (T)template;
        }
        return null;
    }

    public <T extends Template> Collection<T> getTemplatesByTag(String tag) {
        return this.getByTag(tag, null);
    }

    public <T extends Template> Collection<T> getByTag(String tag, Locale locale) {
        ArrayList<Template> result = new ArrayList<Template>(20);
        Collection templates = null;
        Object[] providers = this.templateProviderTracker.getServices();
        int i = 0;
        while (providers != null && i < providers.length) {
            templates = ((TemplateProvider)providers[i]).getTemplates(locale);
            if (templates != null) {
                for (Template t : templates) {
                    if (tag != null) {
                        Set tags = t.getTags();
                        if (tags == null || !tags.contains(tag)) continue;
                        result.add(t);
                        continue;
                    }
                    result.add(t);
                }
            }
            ++i;
        }
        return result;
    }

    public <T extends Template> Collection<T> getTemplatesByTags(Set<String> tags) {
        return this.getByTags(tags, null);
    }

    public <T extends Template> Collection<T> getByTags(Set<String> tags, Locale locale) {
        ArrayList<Template> result = new ArrayList<Template>(20);
        Collection templates = null;
        Object[] providers = this.templateProviderTracker.getServices();
        int i = 0;
        while (providers != null && i < providers.length) {
            templates = ((TemplateProvider)providers[i]).getTemplates(locale);
            if (templates != null) {
                for (Template t : templates) {
                    if (tags != null) {
                        Set tTags = t.getTags();
                        if (tTags == null || !tTags.containsAll(tags)) continue;
                        result.add(t);
                        continue;
                    }
                    result.add(t);
                }
            }
            ++i;
        }
        return result;
    }

    public <T extends Template> Collection<T> getTemplates() {
        return this.getAll(null);
    }

    public <T extends Template> Collection<T> getAll(Locale locale) {
        return this.getByTag(null, locale);
    }

    public void dispose() {
        this.templateProviderTracker.close();
        this.templateProviderTracker = null;
    }

    public Object addingService(ServiceReference reference) {
        TemplateProvider provider = (TemplateProvider)this.bc.getService(reference);
        if (provider != null) {
            this.providers.add(provider);
            this.ruleEngine.templateUpdated(provider.getTemplates(null));
        }
        return provider;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        TemplateProvider provider = (TemplateProvider)service;
        if (provider != null) {
            this.ruleEngine.templateUpdated(provider.getTemplates(null));
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        this.providers.remove(service);
    }
}

