/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.core.internal.RuntimeAction;
import org.eclipse.smarthome.automation.core.internal.RuntimeCondition;
import org.eclipse.smarthome.automation.core.internal.RuntimeRule;
import org.eclipse.smarthome.automation.core.internal.type.ModuleTypeManager;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;

public class ConnectionValidator {
    private static ModuleTypeManager mtManager;

    public static void setManager(ModuleTypeManager mtManager) {
        ConnectionValidator.mtManager = mtManager;
    }

    public static void validateConnections(RuntimeRule r) {
        if (r == null) {
            throw new IllegalArgumentException("Validation of rule  is failed! Rule must not be null!");
        }
        ConnectionValidator.validateConnections(r.getTriggers(), r.getConditions(), r.getActions());
    }

    public static void validateConnections(List<Trigger> triggers, List<Condition> conditions, List<Action> actions) {
        if (!conditions.isEmpty()) {
            for (Condition condition : conditions) {
                ConnectionValidator.validateConditionConnections((RuntimeCondition)condition, triggers);
            }
        }
        if (!actions.isEmpty()) {
            for (Action action : actions) {
                ConnectionValidator.validateActionConnections((RuntimeAction)action, triggers, actions);
            }
        }
    }

    private static void validateActionConnections(RuntimeAction action, List<Trigger> triggers, List<Action> actions) {
        ActionType type = (ActionType)mtManager.get(action.getTypeUID());
        if (type == null) {
            throw new IllegalArgumentException("Condition Type \"" + action.getTypeUID() + "\" does not exist!");
        }
        List inputs = type.getInputs();
        Set<Connection> cons = action.getConnections();
        HashMap<String, Connection> connectionsMap = new HashMap<String, Connection>();
        for (Connection connection : cons) {
            String inputName = connection.getInputName();
            connectionsMap.put(inputName, connection);
        }
        if (inputs != null && !inputs.isEmpty()) {
            for (Input input : inputs) {
                String name = input.getName();
                Connection connection = (Connection)connectionsMap.get(name);
                if (connection == null && input.isRequired()) {
                    throw new IllegalArgumentException("Required input \"" + name + "\" of the condition \"" + action.getId() + "\" not connected");
                }
                if (connection == null) continue;
                ConnectionValidator.checkConnection(connection, input, triggers, actions);
            }
        }
    }

    private static void checkConnection(Connection connection, Input input, List<Trigger> triggers, List<Action> actions) {
        HashMap<String, Action> actionsMap = new HashMap<String, Action>();
        for (Action a : actions) {
            actionsMap.put(a.getId(), a);
        }
        String moduleId = connection.getOuputModuleId();
        Action action = (Action)actionsMap.get(moduleId);
        String msg = " Invalid Connection \"" + connection.getInputName() + "\" : ";
        if (moduleId != null && action != null) {
            String typeUID = action.getTypeUID();
            ActionType actionType = (ActionType)mtManager.get(typeUID);
            if (actionType == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Action Type with UID \"" + typeUID + "\" does not exist!");
            }
            ConnectionValidator.checkCompatibility(msg, connection, input, actionType.getOutputs());
        } else {
            ConnectionValidator.checkConnection(connection, input, triggers);
        }
    }

    private static void validateConditionConnections(RuntimeCondition condition, List<Trigger> triggers) {
        ConditionType type = (ConditionType)mtManager.get(condition.getTypeUID());
        if (type == null) {
            throw new IllegalArgumentException("Condition Type \"" + condition.getTypeUID() + "\" does not exist!");
        }
        List inputs = type.getInputs();
        Set<Connection> cons = condition.getConnections();
        HashMap<String, Connection> connectionsMap = new HashMap<String, Connection>();
        for (Connection connection : cons) {
            String inputName = connection.getInputName();
            connectionsMap.put(inputName, connection);
        }
        if (inputs != null && !inputs.isEmpty()) {
            for (Input input : inputs) {
                String name = input.getName();
                Connection connection = (Connection)connectionsMap.get(name);
                if (connection != null) {
                    ConnectionValidator.checkConnection(connection, input, triggers);
                    continue;
                }
                if (!input.isRequired()) continue;
                throw new IllegalArgumentException("Required input \"" + name + "\" of the condition \"" + condition.getId() + "\" not connected");
            }
        }
    }

    private static void checkConnection(Connection connection, Input input, List<Trigger> triggers) {
        HashMap<String, Trigger> triggersMap = new HashMap<String, Trigger>();
        for (Trigger trigger : triggers) {
            triggersMap.put(trigger.getId(), trigger);
        }
        String moduleId = connection.getOuputModuleId();
        String msg = " Invalid Connection \"" + connection.getInputName() + "\" : ";
        if (moduleId != null) {
            Trigger trigger = (Trigger)triggersMap.get(moduleId);
            if (trigger == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Trigger with ID \"" + moduleId + "\" does not exist!");
            }
            String triggerTypeUID = trigger.getTypeUID();
            TriggerType triggerType = (TriggerType)mtManager.get(triggerTypeUID);
            if (triggerType == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Trigger Type with UID \"" + triggerTypeUID + "\" does not exist!");
            }
            ConnectionValidator.checkCompatibility(msg, connection, input, triggerType.getOutputs());
        }
    }

    private static void checkCompatibility(String msg, Connection connection, Input input, List<Output> outputs) {
        Iterator<Output> iterator;
        String outputName = connection.getOutputName();
        if (outputs != null && !outputs.isEmpty() && (iterator = outputs.iterator()).hasNext()) {
            Output output = iterator.next();
            if (output.getName().equals(outputName)) {
                if (input.getType().equals("*")) {
                    return;
                }
                try {
                    Class<?> outputType = Class.forName(output.getType());
                    Class<?> inputType = Class.forName(input.getType());
                    if (inputType.isAssignableFrom(outputType)) {
                        return;
                    }
                    throw new IllegalArgumentException(String.valueOf(msg) + " Incompatible types : \"" + output.getType() + "\" and \"" + input.getType() + "\".");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (output.getType().equals(input.getType())) {
                        return;
                    }
                    throw new IllegalArgumentException(String.valueOf(msg) + " Incompatible types : \"" + output.getType() + "\" and \"" + input.getType() + "\".");
                }
            }
            throw new IllegalArgumentException(String.valueOf(msg) + " Output with name \"" + outputName + "\" not exists in the Action with ID \"" + connection.getOuputModuleId() + "\"");
        }
    }
}

