/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.defaultscope.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.State;

public class ItemRegistryDelegate
implements Map<String, State> {
    private ItemRegistry itemRegistry;

    public ItemRegistryDelegate(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    @Override
    public int size() {
        return this.itemRegistry.getAll().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            try {
                return this.itemRegistry.getItem((String)key) != null;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public State get(Object key) {
        return ((Item)this.itemRegistry.get((Object)((String)key))).getState();
    }

    @Override
    public State put(String key, State value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public State remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends State> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (Item item : this.itemRegistry.getAll()) {
            keys.add(item.getName());
        }
        return keys;
    }

    @Override
    public Collection<State> values() {
        HashSet<State> values = new HashSet<State>();
        for (Item item : this.itemRegistry.getAll()) {
            values.add(item.getState());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, State>> entrySet() {
        HashSet<Map.Entry<String, State>> entries = new HashSet<Map.Entry<String, State>>();
        for (Item item : this.itemRegistry.getAll()) {
            entries.add((Map.Entry<String, State>)new DefaultMapEntry((Object)item.getName(), (Object)item.getState()));
        }
        return entries;
    }
}

