/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.handler;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.module.script.internal.ScriptModuleActivator;
import org.eclipse.smarthome.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptActionHandler
extends AbstractScriptModuleHandler<Action>
implements ActionHandler {
    private final Logger logger = LoggerFactory.getLogger(ScriptActionHandler.class);
    public static final String SCRIPT_ACTION_ID = "ScriptAction";

    public ScriptActionHandler(Action module) {
        super(module);
    }

    public void dispose() {
    }

    public Map<String, Object> execute(Map<String, ?> context) {
        Object type = ((Action)this.module).getConfiguration().get("type");
        Object script = ((Action)this.module).getConfiguration().get("script");
        if (type instanceof String) {
            if (script instanceof String) {
                ScriptEngine engine = ScriptModuleActivator.getScriptEngine((String)type);
                if (engine != null) {
                    ScriptContext executionContext = this.getExecutionContext(engine, context);
                    try {
                        Object result = engine.eval((String)script, executionContext);
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("result", result);
                        return resultMap;
                    }
                    catch (ScriptException e) {
                        this.logger.error("Script execution failed: {}", (Object)e.getMessage());
                    }
                } else {
                    this.logger.debug("No engine available for script type '{}' in action '{}'.", new Object[]{type, ((Action)this.module).getId()});
                }
            } else {
                this.logger.debug("Script is missing in the configuration of action '{}'.", (Object)((Action)this.module).getId());
            }
        } else {
            this.logger.debug("Script type is missing in the configuration of action '{}'.", (Object)((Action)this.module).getId());
        }
        return null;
    }
}

