/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutomationResourceBundlesEventQueue
implements Runnable,
BundleTrackerCustomizer<Object> {
    public static final String AUTOMATION_RESOURCES_HEADER = "Automation-ResourceType";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<BundleEvent> queue = new ArrayList<BundleEvent>();
    private boolean running = false;
    private boolean closed = false;
    private boolean shared = false;
    private BundleTracker<Object> bTracker;
    private AbstractResourceBundleProvider<Template> tProvider;
    private AbstractResourceBundleProvider<ModuleType> mProvider;
    private AbstractResourceBundleProvider<Rule> rImporter;
    private Map<Bundle, List<Bundle>> hostFragmentMapping = new HashMap<Bundle, List<Bundle>>();
    private PackageAdmin pkgAdmin;

    public AutomationResourceBundlesEventQueue(BundleContext bc, AbstractResourceBundleProvider<Template> tProvider, AbstractResourceBundleProvider<ModuleType> mProvider, AbstractResourceBundleProvider<Rule> rImporter) {
        this.tProvider = tProvider;
        this.mProvider = mProvider;
        this.rImporter = rImporter;
        this.bTracker = new BundleTracker(bc, -2, (BundleTrackerCustomizer)this);
        this.pkgAdmin = (PackageAdmin)bc.getService(bc.getServiceReference(PackageAdmin.class.getName()));
    }

    public void open() {
        if (this.tProvider.isReady() && this.mProvider.isReady() && this.rImporter.isReady()) {
            this.bTracker.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitForEvents = true;
        while (true) {
            List<BundleEvent> l_queue = null;
            AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue = this;
            synchronized (automationResourceBundlesEventQueue) {
                if (this.closed) {
                    this.notifyAll();
                    return;
                }
                if (this.queue.isEmpty()) {
                    if (waitForEvents) {
                        try {
                            this.wait(180000L);
                        }
                        catch (Throwable throwable) {}
                        waitForEvents = false;
                        continue;
                    }
                    this.running = false;
                    this.notifyAll();
                    return;
                }
                l_queue = this.queue;
                this.shared = true;
            }
            for (BundleEvent event : l_queue) {
                try {
                    this.processBundleChanged(event);
                }
                catch (Throwable t) {
                    this.logger.warn("Processing bundle event {}, for automation resource bundle '{}' failed", new Object[]{event.getType(), event.getBundle().getSymbolicName(), t});
                }
            }
            AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue2 = this;
            synchronized (automationResourceBundlesEventQueue2) {
                if (this.shared) {
                    this.queue.clear();
                }
                this.shared = false;
                waitForEvents = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue = this;
        synchronized (automationResourceBundlesEventQueue) {
            this.closed = true;
            this.notifyAll();
        }
        this.bTracker.close();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (this.isAnAutomationProvider(bundle)) {
            if (this.isFragmentBundle(bundle)) {
                List<Bundle> hosts = this.returnHostBundles(bundle);
                if (this.needToProcessFragment(bundle, hosts)) {
                    this.addEvent(bundle, event);
                    this.fillHostFragmentMapping(hosts);
                }
            } else {
                this.addEvent(bundle, event);
                this.fillHostFragmentMapping(bundle);
            }
        }
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        int type = event.getType();
        if (type == 8 || type == 32) {
            this.addEvent(bundle, event);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (this.mProvider.isProviderProcessed(bundle) || this.tProvider.isProviderProcessed(bundle) || this.rImporter.isProviderProcessed(bundle)) {
            this.addEvent(bundle, event);
        }
        if (this.isFragmentBundle(bundle)) {
            for (Map.Entry<Bundle, List<Bundle>> entry : this.hostFragmentMapping.entrySet()) {
                if (!entry.getValue().contains(bundle)) continue;
                Bundle host = entry.getKey();
                this.addEvent(host, new BundleEvent(8, host));
            }
        }
    }

    private boolean isAnAutomationProvider(Bundle bundle) {
        return bundle.findEntries(AbstractResourceBundleProvider.PATH, null, false) != null;
    }

    private List<Bundle> returnHostBundles(Bundle fragment) {
        ArrayList<Bundle> hosts = new ArrayList<Bundle>();
        Bundle[] bundles = this.pkgAdmin.getHosts(fragment);
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                hosts.add(bundles[i]);
                ++i;
            }
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillHostFragmentMapping(Bundle host) {
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        Bundle[] bundles = this.pkgAdmin.getFragments(host);
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                fragments.add(bundles[i]);
                ++i;
            }
        }
        Map<Bundle, List<Bundle>> map = this.hostFragmentMapping;
        synchronized (map) {
            this.hostFragmentMapping.put(host, fragments);
        }
    }

    private void fillHostFragmentMapping(List<Bundle> hosts) {
        for (Bundle host : hosts) {
            this.fillHostFragmentMapping(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needToProcessFragment(Bundle fragment, List<Bundle> hosts) {
        if (hosts.isEmpty()) {
            return false;
        }
        Map<Bundle, List<Bundle>> map = this.hostFragmentMapping;
        synchronized (map) {
            Bundle host;
            List<Bundle> fragments;
            Iterator<Bundle> iterator = hosts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((fragments = this.hostFragmentMapping.get(host = iterator.next())) == null || !fragments.contains(fragment));
            return false;
        }
    }

    private boolean isFragmentBundle(Bundle bundle) {
        Dictionary h = bundle.getHeaders();
        return h.get("Fragment-Host") != null;
    }

    private synchronized void addEvent(Bundle bundle, BundleEvent event) {
        if (this.closed) {
            return;
        }
        if (this.shared) {
            this.queue = new ArrayList<BundleEvent>();
            this.shared = false;
        }
        if (event == null) {
            event = this.initializeEvent(bundle);
        }
        if (this.queue.add(event)) {
            this.logger.debug("Process bundle event {}, for automation bundle '{}' ", (Object)event.getType(), (Object)event.getBundle().getSymbolicName());
            if (this.running) {
                this.notifyAll();
            } else {
                Thread th = new Thread((Runnable)this, "Automation Provider Processing Queue");
                th.start();
                this.running = true;
            }
        }
    }

    private BundleEvent initializeEvent(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return new BundleEvent(1, bundle);
            }
            case 4: {
                return new BundleEvent(32, bundle);
            }
        }
        return new BundleEvent(2, bundle);
    }

    private void processBundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (this.isFragmentBundle(bundle)) {
            this.processFragmentBundleUpdated(this.returnHostBundles(bundle));
        } else {
            switch (event.getType()) {
                case 16: {
                    this.processBundleUninstalled(bundle);
                    break;
                }
                default: {
                    this.processBundleDefault(bundle);
                }
            }
        }
    }

    private void processFragmentBundleUpdated(List<Bundle> hosts) {
        for (Bundle host : hosts) {
            this.processBundleDefault(host);
        }
    }

    private void processBundleUninstalled(Bundle bundle) {
        if (this.mProvider.isProviderProcessed(bundle)) {
            this.mProvider.processAutomationProviderUninstalled(bundle);
        }
        if (this.tProvider.isProviderProcessed(bundle)) {
            this.tProvider.processAutomationProviderUninstalled(bundle);
        }
        if (this.rImporter.isProviderProcessed(bundle)) {
            this.rImporter.processAutomationProviderUninstalled(bundle);
        }
        this.hostFragmentMapping.remove(bundle);
    }

    private void processBundleDefault(Bundle bundle) {
        this.mProvider.processAutomationProvider(bundle);
        this.tProvider.processAutomationProvider(bundle);
        this.rImporter.processAutomationProvider(bundle);
    }
}

