/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleProvider;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RuleResourceBundleImporter
extends AbstractResourceBundleProvider<Rule> {
    protected RuleRegistry ruleRegistry;
    private RuleProvider ruleProvider;
    private ServiceTracker rulesTracker;

    public RuleResourceBundleImporter(BundleContext context) {
        super(context);
        this.path = String.valueOf(PATH) + "/rules/";
        try {
            Filter filter = this.bc.createFilter("(|(objectClass=" + RuleRegistry.class.getName() + ")(objectClass=" + RuleProvider.class.getName() + "))");
            this.rulesTracker = new ServiceTracker(this.bc, filter, new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    Object service = RuleResourceBundleImporter.this.bc.getService(reference);
                    if (service instanceof RuleRegistry) {
                        RuleResourceBundleImporter.this.ruleRegistry = (RuleRegistry)service;
                        RuleResourceBundleImporter.this.queue.open();
                        return service;
                    }
                    if (service instanceof ManagedProvider) {
                        RuleResourceBundleImporter.this.ruleProvider = (RuleProvider)service;
                        RuleResourceBundleImporter.this.queue.open();
                        return service;
                    }
                    return null;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                    if (service instanceof RuleRegistry) {
                        RuleResourceBundleImporter.this.ruleRegistry = null;
                    } else if (service instanceof RuleProvider) {
                        RuleResourceBundleImporter.this.ruleProvider = null;
                    }
                }
            });
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    @Override
    public void close() {
        if (this.rulesTracker != null) {
            this.rulesTracker.close();
            this.rulesTracker = null;
            this.ruleRegistry = null;
            this.ruleProvider = null;
        }
        super.close();
    }

    @Override
    public void setQueue(AutomationResourceBundlesEventQueue queue) {
        super.setQueue(queue);
        this.rulesTracker.open();
    }

    @Override
    public Object addingService(ServiceReference reference) {
        if (reference.getProperty("parser.type").equals("parser.rule")) {
            return super.addingService(reference);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.ruleRegistry != null && this.ruleProvider != null && this.queue != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processAutomationProvider(Bundle bundle) {
        this.logger.debug("Parse rules from bundle '{}' ", (Object)bundle.getSymbolicName());
        Enumeration urlEnum = null;
        try {
            urlEnum = bundle.findEntries(this.path, null, false);
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        if (urlEnum == null) {
            return;
        }
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        while (urlEnum.hasMoreElements()) {
            URL url = (URL)urlEnum.nextElement();
            String parserType = this.getParserType(url);
            Parser parser = (Parser)this.parsers.get(parserType);
            Map map = this.waitingProviders;
            synchronized (map) {
                ArrayList<URL> urlList = (ArrayList<URL>)this.waitingProviders.get(bundle);
                if (parser != null) {
                    if (urlList != null && urlList.remove(url) && urlList.isEmpty()) {
                        this.waitingProviders.remove(bundle);
                    }
                } else if (parser == null) {
                    if (urlList == null) {
                        urlList = new ArrayList<URL>();
                    }
                    urlList.add(url);
                    this.waitingProviders.put(bundle, urlList);
                }
            }
            if (parser == null) continue;
            InputStreamReader reader = null;
            try {
                try {
                    reader = new InputStreamReader(url.openStream());
                    this.importData(vendor, (Parser<Rule>)parser, reader);
                }
                catch (IOException e) {
                    this.logger.error("Can't read from resource of bundle with ID " + bundle.getBundleId(), (Throwable)e);
                    this.processAutomationProviderUninstalled(bundle);
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<Rule> importData(Vendor vendor, Parser<Rule> parser, InputStreamReader inputStreamReader) {
        Set providedRules = null;
        try {
            providedRules = parser.parse(inputStreamReader);
        }
        catch (ParsingException parsingException) {}
        if (providedRules != null && !providedRules.isEmpty()) {
            for (Rule rule : providedRules) {
                if (rule == null) continue;
                try {
                    if (rule.getUID() == null) {
                        rule = this.setUID(vendor, rule);
                    }
                    this.ruleRegistry.add((Object)rule);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.debug("Not importing rule '{}' since a rule with this id already exists", (Object)rule.getUID());
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Not importing rule '{}' since the rule registry is in an invalid state: {}", new Object[]{rule.getUID(), e.getMessage()});
                }
            }
            Map map = this.providerPortfolio;
            synchronized (map) {
                if (this.providerPortfolio.get(vendor) == null) {
                    this.providerPortfolio.put(vendor, Collections.emptyList());
                }
            }
        }
        return providedRules;
    }

    private Rule setUID(Vendor vendor, Rule rule) {
        String uid = String.valueOf(vendor.getVendorID()) + vendor.count();
        Rule r = new Rule(uid, rule.getTriggers(), rule.getConditions(), rule.getActions(), rule.getConfigurationDescriptions(), rule.getConfiguration());
        r.setName(rule.getName());
        r.setDescription(rule.getDescription());
        r.setTags(rule.getTags());
        return r;
    }
}

