/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.osgi.framework.Bundle;

public class ConfigDescriptionParameterI18nUtil {
    private static final Pattern delimiter = Pattern.compile("[:=\\s]");

    public static List<ConfigDescriptionParameter> getLocalizedConfigurationDescription(I18nProvider i18nProvider, List<ConfigDescriptionParameter> config, Bundle bundle, String uid, String prefix, Locale locale) {
        ArrayList<ConfigDescriptionParameter> configDescriptions = new ArrayList<ConfigDescriptionParameter>();
        if (config != null) {
            for (ConfigDescriptionParameter parameter : config) {
                String parameterName = parameter.getName();
                String llabel = ConfigDescriptionParameterI18nUtil.getModuleTypeConfigParameterLabel(i18nProvider, bundle, uid, parameterName, parameter.getLabel(), prefix, locale);
                String ldescription = ConfigDescriptionParameterI18nUtil.getModuleTypeConfigParameterDescription(i18nProvider, bundle, uid, parameterName, parameter.getDescription(), prefix, locale);
                String lpattern = ConfigDescriptionParameterI18nUtil.getParameterPattern(i18nProvider, bundle, uid, parameterName, parameter.getPattern(), prefix, locale);
                List<ParameterOption> loptions = ConfigDescriptionParameterI18nUtil.getLocalizedOptions(i18nProvider, parameter.getOptions(), bundle, uid, parameterName, prefix, locale);
                String lunitLabel = ConfigDescriptionParameterI18nUtil.getUnitLabel(i18nProvider, bundle, uid, parameterName, parameter.getUnitLabel(), prefix, locale);
                configDescriptions.add(ConfigDescriptionParameterBuilder.create((String)parameterName, (ConfigDescriptionParameter.Type)parameter.getType()).withMinimum(parameter.getMinimum()).withMaximum(parameter.getMaximum()).withStepSize(parameter.getStepSize()).withPattern(lpattern).withRequired(Boolean.valueOf(parameter.isRequired())).withMultiple(parameter.isMultiple()).withReadOnly(parameter.isReadOnly()).withContext(parameter.getContext()).withDefault(parameter.getDefault()).withLabel(llabel).withDescription(ldescription).withFilterCriteria(parameter.getFilterCriteria()).withGroupName(parameter.getGroupName()).withAdvanced(Boolean.valueOf(parameter.isAdvanced())).withOptions(loptions).withLimitToOptions(Boolean.valueOf(parameter.getLimitToOptions())).withMultipleLimit(parameter.getMultipleLimit()).withUnit(parameter.getUnit()).withUnitLabel(lunitLabel).build());
            }
        }
        return configDescriptions;
    }

    private static String getParameterPattern(I18nProvider i18nProvider, Bundle bundle, String uid, String parameterName, String defaultPattern, String prefix, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultPattern) ? I18nUtil.stripConstant((String)defaultPattern) : ConfigDescriptionParameterI18nUtil.inferKey(prefix, uid, parameterName, "pattern");
        return i18nProvider.getText(bundle, key, defaultPattern, locale);
    }

    private static String getModuleTypeConfigParameterLabel(I18nProvider i18nProvider, Bundle bundle, String uid, String parameterName, String defaultLabel, String prefix, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : ConfigDescriptionParameterI18nUtil.inferKey(prefix, uid, parameterName, "label");
        return i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private static String getModuleTypeConfigParameterDescription(I18nProvider i18nProvider, Bundle bundle, String uid, String parameterName, String defaultDescription, String prefix, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : ConfigDescriptionParameterI18nUtil.inferKey(prefix, uid, parameterName, "description");
        return i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private static String getUnitLabel(I18nProvider i18nProvider, Bundle bundle, String uid, String parameterName, String defaultUnitLabel, String prefix, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultUnitLabel) ? I18nUtil.stripConstant((String)defaultUnitLabel) : ConfigDescriptionParameterI18nUtil.inferKey(prefix, uid, parameterName, "unitLabel");
        return i18nProvider.getText(bundle, key, defaultUnitLabel, locale);
    }

    private static List<ParameterOption> getLocalizedOptions(I18nProvider i18nProvider, List<ParameterOption> originalOptions, Bundle bundle, String uid, String parameterName, String prefix, Locale locale) {
        if (originalOptions == null || originalOptions.isEmpty()) {
            return originalOptions;
        }
        ArrayList<ParameterOption> localizedOptions = new ArrayList<ParameterOption>();
        for (ParameterOption option : originalOptions) {
            String localizedLabel = ConfigDescriptionParameterI18nUtil.getParameterOptionLabel(i18nProvider, bundle, uid, parameterName, option.getValue(), option.getLabel(), prefix, locale);
            ParameterOption localizedOption = new ParameterOption(option.getValue(), localizedLabel);
            localizedOptions.add(localizedOption);
        }
        return localizedOptions;
    }

    private static String getParameterOptionLabel(I18nProvider i18nProvider, Bundle bundle, String uid, String parameterName, String optionValue, String defaultOptionLabel, String prefix, Locale locale) {
        if (!ConfigDescriptionParameterI18nUtil.isValidPropertyKey(optionValue)) {
            return defaultOptionLabel;
        }
        String key = I18nUtil.isConstant((String)defaultOptionLabel) ? I18nUtil.stripConstant((String)defaultOptionLabel) : ConfigDescriptionParameterI18nUtil.inferKey(prefix, uid, parameterName, "option." + optionValue);
        return i18nProvider.getText(bundle, key, defaultOptionLabel, locale);
    }

    private static String inferKey(String prefix, String uid, String parameterName, String lastSegment) {
        return String.valueOf(prefix) + uid + ".config." + parameterName + "." + lastSegment;
    }

    private static boolean isValidPropertyKey(String key) {
        if (key != null) {
            return !delimiter.matcher(key).find();
        }
        return false;
    }
}

