/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="module-types")
@Api(value="module-types")
public class ModuleTypeResource
implements RESTResource {
    private ModuleTypeRegistry moduleTypeRegistry;
    @Context
    private UriInfo uriInfo;

    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available module types.", response=ModuleType.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @QueryParam(value="tags") @ApiParam(value="tags for filtering", required=false) String tagList, @QueryParam(value="type") @ApiParam(value="filtering by action, condition or trigger", required=false) String type) {
        Locale locale = LocaleUtil.getLocale((String)language);
        HashSet<String> tags = tagList != null ? new HashSet<String>(Arrays.asList(tagList.split(","))) : null;
        ArrayList allModules = new ArrayList();
        if (type == null || type.equals("trigger")) {
            if (tags == null) {
                allModules.addAll(this.moduleTypeRegistry.getAll(TriggerType.class, locale));
            } else {
                Collection triggers = this.moduleTypeRegistry.getByTags(tags, locale);
                allModules.addAll(triggers);
            }
        }
        if (type == null || type.equals("condition")) {
            if (tags == null) {
                allModules.addAll(this.moduleTypeRegistry.getAll(ConditionType.class, locale));
            } else {
                allModules.addAll(this.moduleTypeRegistry.getByTags(tags, locale));
            }
        }
        if (type == null || type.equals("action")) {
            if (tags == null) {
                allModules.addAll(this.moduleTypeRegistry.getAll(ActionType.class, locale));
            } else {
                allModules.addAll(this.moduleTypeRegistry.getByTags(tags, locale));
            }
        }
        return Response.ok(allModules).build();
    }

    @GET
    @Path(value="/{moduleTypeUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a module type corresponding to the given UID.", response=ModuleType.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Module Type corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="moduleTypeUID") @ApiParam(value="moduleTypeUID", required=true) String moduleTypeUID) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ModuleType moduleType = this.moduleTypeRegistry.get(moduleTypeUID, locale);
        if (moduleType != null) {
            return Response.ok((Object)moduleType).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

