/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="templates")
@Api(value="templates")
public class TemplateResource
implements RESTResource {
    private TemplateRegistry templateRegistry;
    @Context
    private UriInfo uriInfo;

    protected void setTemplateRegistry(TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    protected void unsetTemplateRegistry(TemplateRegistry templateRegistry) {
        this.templateRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available templates.", response=Template.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        return Response.ok((Object)this.templateRegistry.getAll(locale)).build();
    }

    @GET
    @Path(value="/{templateUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a template corresponding to the given UID.", response=Template.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Template corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="templateUID") @ApiParam(value="templateUID", required=true) String templateUID) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Template template = this.templateRegistry.get(templateUID, locale);
        if (template != null) {
            return Response.ok((Object)template).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

