/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.handler;

import java.math.BigDecimal;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadio;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSInternetRadioHandler
extends BaseThingHandler {
    private Logger logger = LoggerFactory.getLogger(FSInternetRadioHandler.class);
    private FrontierSiliconRadio radio;
    private ScheduledFuture<?> updateJob;
    private Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            if (FSInternetRadioHandler.this.radio == null) {
                for (Channel channel : FSInternetRadioHandler.this.getThing().getChannels()) {
                    FSInternetRadioHandler.this.updateState(channel.getUID(), (State)UnDefType.UNDEF);
                }
                FSInternetRadioHandler.this.radioLogin(false);
                return;
            }
            try {
                boolean radioOn = FSInternetRadioHandler.this.radio.getPower();
                for (Channel channel : FSInternetRadioHandler.this.getThing().getChannels()) {
                    if (!radioOn && !"power".equals(channel.getUID().getId())) {
                        FSInternetRadioHandler.this.updateState(channel.getUID(), (State)UnDefType.UNDEF);
                        continue;
                    }
                    if (!FSInternetRadioHandler.this.isLinked(channel.getUID().getId())) continue;
                    switch (channel.getUID().getId()) {
                        case "power": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)(radioOn ? OnOffType.ON : OnOffType.OFF));
                            break;
                        }
                        case "volume-absolute": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)DecimalType.valueOf((String)String.valueOf(FSInternetRadioHandler.this.radio.getVolumeAbsolute())));
                            break;
                        }
                        case "volume-percent": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)PercentType.valueOf((String)String.valueOf(FSInternetRadioHandler.this.radio.getVolumePercent())));
                            break;
                        }
                        case "mode": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)DecimalType.valueOf((String)String.valueOf(FSInternetRadioHandler.this.radio.getMode())));
                            break;
                        }
                        case "mute": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)(FSInternetRadioHandler.this.radio.getMuted() ? OnOffType.ON : OnOffType.OFF));
                            break;
                        }
                        case "play-info-name": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)StringType.valueOf((String)FSInternetRadioHandler.this.radio.getPlayInfoName()));
                            break;
                        }
                        case "play-info-text": {
                            FSInternetRadioHandler.this.updateState(channel.getUID(), (State)StringType.valueOf((String)FSInternetRadioHandler.this.radio.getPlayInfoText()));
                            break;
                        }
                        default: {
                            FSInternetRadioHandler.this.logger.warn("Ignoring unknown channel during update: " + channel.getLabel());
                        }
                        case "preset": 
                    }
                }
                FSInternetRadioHandler.this.updateStatus(ThingStatus.ONLINE);
            }
            catch (Exception e) {
                FSInternetRadioHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
            }
        }
    };

    public FSInternetRadioHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.radioLogin(true);
        BigDecimal period = (BigDecimal)this.getThing().getConfiguration().get("refresh");
        if (period != null && period.intValue() > 0) {
            this.updateJob = this.scheduler.scheduleWithFixedDelay(this.updateRunnable, period.intValue(), period.intValue(), TimeUnit.SECONDS);
        }
    }

    private void radioLogin(boolean logFailure) {
        final String ip = (String)this.getThing().getConfiguration().get("ip");
        final BigDecimal port = (BigDecimal)this.getThing().getConfiguration().get("port");
        final String pin = (String)this.getThing().getConfiguration().get("pin");
        if (ip == null || pin == null || port.intValue() == 0) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Configuration incomplete");
        } else {
            this.scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    FSInternetRadioHandler.this.logger.debug("creating new connection to " + ip + ":" + port);
                    try {
                        FrontierSiliconRadio tmpRadio = new FrontierSiliconRadio(ip, port.intValue(), pin);
                        tmpRadio.login();
                        FSInternetRadioHandler.this.radio = tmpRadio;
                        FSInternetRadioHandler.this.updateStatus(ThingStatus.ONLINE);
                        FSInternetRadioHandler.this.updateRunnable.run();
                    }
                    catch (Exception e) {
                        FSInternetRadioHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel(true);
        }
        this.updateJob = null;
        this.radio = null;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (this.radio == null) {
            this.logger.debug("Ignoring command " + channelUID.getId() + " = " + command + " because device is offline.");
            if (ThingStatus.ONLINE.equals((Object)this.getThing().getStatus())) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            }
            return;
        }
        try {
            switch (channelUID.getId()) {
                case "power": {
                    if (OnOffType.ON.equals((Object)command)) {
                        this.radio.setPower(true);
                    } else if (OnOffType.OFF.equals((Object)command)) {
                        this.radio.setPower(false);
                    }
                    this.scheduler.schedule(this.updateRunnable, 4L, TimeUnit.SECONDS);
                    break;
                }
                case "volume-percent": {
                    if (IncreaseDecreaseType.INCREASE.equals((Object)command) || UpDownType.UP.equals((Object)command)) {
                        this.radio.increaseVolumeAbsolute();
                    } else if (IncreaseDecreaseType.DECREASE.equals((Object)command) || UpDownType.DOWN.equals((Object)command)) {
                        this.radio.decreaseVolumeAbsolute();
                    } else if (command instanceof PercentType) {
                        this.radio.setVolumePercent(((PercentType)command).intValue());
                    }
                    this.scheduler.schedule(this.updateRunnable, 1L, TimeUnit.SECONDS);
                    break;
                }
                case "volume-absolute": {
                    if (IncreaseDecreaseType.INCREASE.equals((Object)command) || UpDownType.UP.equals((Object)command)) {
                        this.radio.increaseVolumeAbsolute();
                    } else if (IncreaseDecreaseType.DECREASE.equals((Object)command) || UpDownType.DOWN.equals((Object)command)) {
                        this.radio.decreaseVolumeAbsolute();
                    } else if (command instanceof DecimalType) {
                        this.radio.setVolumeAbsolute(((DecimalType)command).intValue());
                    }
                    this.scheduler.schedule(this.updateRunnable, 1L, TimeUnit.SECONDS);
                    break;
                }
                case "mode": {
                    if (!(command instanceof DecimalType)) break;
                    this.radio.setMode(((DecimalType)command).intValue());
                    break;
                }
                case "preset": {
                    if (!(command instanceof DecimalType)) break;
                    this.radio.setPreset(((DecimalType)command).intValue());
                    break;
                }
                case "mute": {
                    if (!(command instanceof OnOffType)) break;
                    this.radio.setMuted(OnOffType.ON.equals((Object)command));
                    break;
                }
                default: {
                    this.logger.warn("Ignoring unknown command: " + command);
                }
            }
            this.updateStatus(ThingStatus.ONLINE);
        }
        catch (Exception e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        }
    }
}

