/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal.radio;

import java.io.IOException;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioApiResult;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioConnection;

public class FrontierSiliconRadio {
    private static final String REQUEST_SET_POWER = "SET/netRemote.sys.power";
    private static final String REQUEST_GET_POWER = "GET/netRemote.sys.power";
    private static final String REQUEST_GET_MODE = "GET/netRemote.sys.mode";
    private static final String REQUEST_SET_MODE = "SET/netRemote.sys.mode";
    private static final String REQUEST_SET_VOLUME = "SET/netRemote.sys.audio.volume";
    private static final String REQUEST_GET_VOLUME = "GET/netRemote.sys.audio.volume";
    private static final String REQUEST_SET_MUTE = "SET/netRemote.sys.audio.mute";
    private static final String REQUEST_GET_MUTE = "GET/netRemote.sys.audio.mute";
    private static final String REQUEST_SET_PRESET = "SET/netRemote.nav.state";
    private static final String REQUEST_SET_PRESET_ACTION = "SET/netRemote.nav.action.selectPreset";
    private static final String REQUEST_GET_PLAY_INFO_TEXT = "GET/netRemote.play.info.text";
    private static final String REQUEST_GET_PLAY_INFO_NAME = "GET/netRemote.play.info.name";
    private FrontierSiliconRadioConnection conn;
    private int currentVolume = 0;

    public FrontierSiliconRadio(String hostname, int port, String pin) {
        this.conn = new FrontierSiliconRadioConnection(hostname, port, pin);
    }

    public void login() throws IOException {
        this.conn.doLogin();
    }

    public boolean getPower() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_POWER);
        return result.getValueU8AsBoolean();
    }

    public void setPower(boolean powerOn) throws IOException {
        String params = "value=" + (powerOn ? "1" : "0");
        this.conn.doRequest(REQUEST_SET_POWER, params);
    }

    public int getVolumeAbsolute() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_VOLUME);
        this.currentVolume = result.getValueU8AsInt();
        return this.currentVolume;
    }

    public int getVolumePercent() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_VOLUME);
        this.currentVolume = result.getValueU8AsInt();
        return this.currentVolume * 100 / 32;
    }

    public void setVolumeAbsolute(int volume) throws IOException {
        int newVolume = volume < 0 ? 0 : (volume > 32 ? 32 : volume);
        String params = "value=" + newVolume;
        this.conn.doRequest(REQUEST_SET_VOLUME, params);
        this.currentVolume = volume;
    }

    public void setVolumePercent(int volume) throws IOException {
        int newVolumePercent = volume < 0 ? 0 : (volume > 100 ? 100 : volume);
        int newVolumeAbsolute = newVolumePercent * 32 / 100;
        String params = "value=" + newVolumeAbsolute;
        this.conn.doRequest(REQUEST_SET_VOLUME, params);
        this.currentVolume = volume;
    }

    public void increaseVolumeAbsolute() throws IOException {
        if (this.currentVolume < 32) {
            this.setVolumeAbsolute(this.currentVolume + 1);
        }
    }

    public void decreaseVolumeAbsolute() throws IOException {
        if (this.currentVolume > 0) {
            this.setVolumeAbsolute(this.currentVolume - 1);
        }
    }

    public int getMode() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_MODE);
        return result.getValueU32AsInt();
    }

    public void setMode(int mode) throws IOException {
        String params = "value=" + mode;
        this.conn.doRequest(REQUEST_SET_MODE, params);
    }

    public String getPlayInfoName() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_PLAY_INFO_NAME);
        return result.getValueC8ArrayAsString();
    }

    public String getPlayInfoText() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_PLAY_INFO_TEXT);
        return result.getValueC8ArrayAsString();
    }

    public void setPreset(Integer presetId) throws IOException {
        this.conn.doRequest(REQUEST_SET_PRESET, "value=1");
        this.conn.doRequest(REQUEST_SET_PRESET_ACTION, "value=" + presetId.toString());
        this.conn.doRequest(REQUEST_SET_PRESET, "value=0");
    }

    public boolean getMuted() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest(REQUEST_GET_MUTE);
        return result.getValueU8AsBoolean();
    }

    public void setMuted(boolean muted) throws IOException {
        String params = "value=" + (muted ? "1" : "0");
        this.conn.doRequest(REQUEST_SET_MUTE, params);
    }
}

