/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.handler;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import nl.q42.jue.Config;
import nl.q42.jue.FullConfig;
import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import nl.q42.jue.Light;
import nl.q42.jue.State;
import nl.q42.jue.StateUpdate;
import nl.q42.jue.exceptions.ApiException;
import nl.q42.jue.exceptions.DeviceOffException;
import nl.q42.jue.exceptions.LinkButtonException;
import nl.q42.jue.exceptions.UnauthorizedException;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.handler.LightStateConverter;
import org.eclipse.smarthome.binding.hue.handler.LightStatusListener;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueBridgeHandler
extends BaseBridgeHandler {
    private static final String LIGHT_STATE_ADDED = "added";
    private static final String LIGHT_STATE_CHANGED = "changed";
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_BRIDGE);
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private static final String DEVICE_TYPE = "EclipseSmartHome";
    private Logger logger = LoggerFactory.getLogger(HueBridgeHandler.class);
    private Map<String, FullLight> lastLightStates = new HashMap<String, FullLight>();
    private boolean lastBridgeConnectionState = false;
    private List<LightStatusListener> lightStatusListeners = new CopyOnWriteArrayList<LightStatusListener>();
    private ScheduledFuture<?> pollingJob;
    private Runnable pollingRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                try {
                    FullConfig fullConfig = HueBridgeHandler.this.bridge.getFullConfig();
                    if (!HueBridgeHandler.this.lastBridgeConnectionState) {
                        HueBridgeHandler.this.lastBridgeConnectionState = HueBridgeHandler.this.tryResumeBridgeConnection();
                    }
                    if (HueBridgeHandler.this.lastBridgeConnectionState) {
                        HashMap lastLightStateCopy = new HashMap(HueBridgeHandler.this.lastLightStates);
                        for (FullLight fullLight : fullConfig.getLights()) {
                            String lightId = fullLight.getId();
                            if (lastLightStateCopy.containsKey(lightId)) {
                                FullLight lastFullLight = (FullLight)lastLightStateCopy.remove(lightId);
                                State lastFullLightState = lastFullLight.getState();
                                HueBridgeHandler.this.lastLightStates.put(lightId, fullLight);
                                if (HueBridgeHandler.this.isEqual(lastFullLightState, fullLight.getState())) continue;
                                HueBridgeHandler.this.logger.debug("Status update for Hue light {} detected.", (Object)lightId);
                                HueBridgeHandler.this.notifyLightStatusListeners(fullLight, HueBridgeHandler.LIGHT_STATE_CHANGED);
                                continue;
                            }
                            HueBridgeHandler.this.lastLightStates.put(lightId, fullLight);
                            HueBridgeHandler.this.logger.debug("Hue light {} added.", (Object)lightId);
                            HueBridgeHandler.this.notifyLightStatusListeners(fullLight, HueBridgeHandler.LIGHT_STATE_ADDED);
                        }
                        for (Map.Entry entry : lastLightStateCopy.entrySet()) {
                            HueBridgeHandler.this.lastLightStates.remove(entry.getKey());
                            HueBridgeHandler.this.logger.debug("Hue light {} removed.", entry.getKey());
                            for (LightStatusListener lightStatusListener : HueBridgeHandler.this.lightStatusListeners) {
                                try {
                                    lightStatusListener.onLightRemoved(HueBridgeHandler.this.bridge, (FullLight)entry.getValue());
                                }
                                catch (Exception e) {
                                    HueBridgeHandler.this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                                }
                            }
                        }
                        Config config = fullConfig.getConfig();
                        if (config != null) {
                            Map properties = HueBridgeHandler.this.editProperties();
                            properties.put("serialNumber", config.getMACAddress());
                            properties.put("firmwareVersion", config.getSoftwareVersion());
                            HueBridgeHandler.this.updateProperties(properties);
                        }
                    }
                }
                catch (IllegalStateException | UnauthorizedException throwable) {
                    if (this.isReachable(HueBridgeHandler.this.bridge.getIPAddress())) {
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onNotAuthenticated(HueBridgeHandler.this.bridge);
                    } else if (HueBridgeHandler.this.lastBridgeConnectionState) {
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onConnectionLost(HueBridgeHandler.this.bridge);
                    }
                }
                catch (Exception exception) {
                    if (HueBridgeHandler.this.bridge != null && HueBridgeHandler.this.lastBridgeConnectionState) {
                        HueBridgeHandler.this.logger.debug("Connection to Hue Bridge {} lost.", (Object)HueBridgeHandler.this.bridge.getIPAddress());
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onConnectionLost(HueBridgeHandler.this.bridge);
                    }
                }
            }
            catch (Throwable t) {
                HueBridgeHandler.this.logger.error("An unexpected error occurred: {}", (Object)t.getMessage(), (Object)t);
            }
        }

        private boolean isReachable(String ipAddress) {
            try {
                HueBridgeHandler.this.bridge.authenticate("invalid");
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ApiException e) {
                return !e.getMessage().contains("SocketTimeout") && !e.getMessage().contains("ConnectException");
            }
            return true;
        }
    };
    private HueBridge bridge = null;

    public HueBridgeHandler(Bridge hueBridge) {
        super(hueBridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void updateLightState(FullLight light, StateUpdate stateUpdate) {
        if (this.bridge != null) {
            try {
                this.bridge.setLightState((Light)light, stateUpdate);
            }
            catch (DeviceOffException deviceOffException) {
                this.updateLightState(light, LightStateConverter.toOnOffLightState(OnOffType.ON));
                this.updateLightState(light, stateUpdate);
            }
            catch (IOException | ApiException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalStateException e) {
                this.logger.trace("Error while accessing light: {}", (Object)e.getMessage());
            }
        } else {
            this.logger.warn("No bridge connected or selected. Cannot set light state.");
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposed.");
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        if (this.bridge != null) {
            this.bridge = null;
        }
    }

    public void initialize() {
        this.logger.debug("Initializing hue bridge handler.");
        if (this.getConfig().get("ipAddress") != null) {
            if (this.bridge == null) {
                this.bridge = new HueBridge((String)this.getConfig().get("ipAddress"));
                this.bridge.setTimeout(5000);
            }
            this.onUpdate();
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Cannot connect to hue bridge. IP address not set.");
        }
    }

    private synchronized void onUpdate() {
        if (this.bridge != null && (this.pollingJob == null || this.pollingJob.isCancelled())) {
            int pollingInterval = 10;
            try {
                Object pollingIntervalConfig = this.getConfig().get("pollingInterval");
                if (pollingIntervalConfig != null) {
                    pollingInterval = ((BigDecimal)pollingIntervalConfig).intValue();
                } else {
                    this.logger.info("Polling interval not configured for this hue bridge. Using default value: {}s", (Object)pollingInterval);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.info("Wrong configuration value for polling interval. Using default value: {}s", (Object)pollingInterval);
            }
            this.pollingJob = this.scheduler.scheduleAtFixedRate(this.pollingRunnable, 1L, pollingInterval, TimeUnit.SECONDS);
        }
    }

    public void onConnectionLost(HueBridge bridge) {
        this.logger.debug("Bridge connection lost. Updating thing status to OFFLINE.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.BRIDGE_OFFLINE);
    }

    public void onConnectionResumed(HueBridge bridge) {
        this.logger.debug("Bridge connection resumed. Updating thing status to ONLINE.");
        this.updateStatus(ThingStatus.ONLINE);
        for (Thing thing : this.getThing().getThings()) {
            ThingHandler handler = thing.getHandler();
            if (handler == null) continue;
            handler.initialize();
        }
    }

    private boolean tryResumeBridgeConnection() {
        this.logger.debug("Connection to Hue Bridge {} established.", (Object)this.bridge.getIPAddress());
        if (this.getConfig().get("userName") == null) {
            this.logger.warn("User name for Hue bridge authentication not available in configuration. Setting ThingStatus to offline.");
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "User name is not properly configured - please check log files");
            return false;
        }
        this.onConnectionResumed(this.bridge);
        return true;
    }

    public void onNotAuthenticated(HueBridge bridge) {
        String userName = (String)this.getConfig().get("userName");
        if (userName == null) {
            this.createUser(bridge);
        } else {
            try {
                bridge.authenticate(userName);
            }
            catch (Exception e) {
                this.handleAuthenticationFailure(e, userName);
            }
        }
    }

    private void createUser(HueBridge bridge) {
        try {
            String newUser = this.createUserOnPhysicalBridge(bridge);
            this.updateBridgeThingConfiguration(newUser);
        }
        catch (LinkButtonException ex) {
            this.handleLinkButtonNotPressed(ex);
        }
        catch (Exception ex) {
            this.handleExceptionWhileCreatingUser(ex);
        }
    }

    private String createUserOnPhysicalBridge(HueBridge bridge) throws IOException, ApiException {
        this.logger.info("Creating new user on Hue bridge {} - please press the pairing button on the bridge.", this.getConfig().get("ipAddress"));
        String userName = bridge.link(DEVICE_TYPE);
        this.logger.info("User '{}' has been successfully added to Hue bridge.", (Object)userName);
        return userName;
    }

    private void updateBridgeThingConfiguration(String userName) {
        Configuration config = this.editConfiguration();
        config.put("userName", (Object)userName);
        try {
            this.updateConfiguration(config);
            this.logger.debug("Updated configuration parameter {} to '{}'", (Object)"userName", (Object)userName);
        }
        catch (IllegalStateException e) {
            this.logger.trace("Configuration update failed.", (Throwable)e);
            this.logger.warn("Unable to update configuration of Hue bridge.");
            this.logger.warn("Please configure the following user name manually: {}", (Object)userName);
        }
    }

    private void handleAuthenticationFailure(Exception ex, String userName) {
        this.logger.warn("User {} is not authenticated on Hue bridge {}", (Object)userName, this.getConfig().get("ipAddress"));
        this.logger.warn("Please configure a valid user or remove user from configuration to generate a new one.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Authentication failed - remove user name from configuration to generate a new one.");
    }

    private void handleLinkButtonNotPressed(LinkButtonException ex) {
        this.logger.debug("Failed creating new user on Hue bridge: {}", (Object)ex.getMessage());
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Not authenticated - press pairing button on the bridge.");
    }

    private void handleExceptionWhileCreatingUser(Exception ex) {
        this.logger.warn("Failed creating new user on Hue bridge", (Throwable)ex);
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Failed to create new user on bridge: " + ex.getMessage());
    }

    public boolean registerLightStatusListener(LightStatusListener lightStatusListener) {
        if (lightStatusListener == null) {
            throw new NullPointerException("It's not allowed to pass a null LightStatusListener.");
        }
        boolean result = this.lightStatusListeners.add(lightStatusListener);
        if (result) {
            this.onUpdate();
            for (FullLight light : this.lastLightStates.values()) {
                lightStatusListener.onLightAdded(this.bridge, light);
            }
        }
        return result;
    }

    public boolean unregisterLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.remove(lightStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    public FullLight getLightById(String lightId) {
        return this.lastLightStates.get(lightId);
    }

    public List<FullLight> getFullLights() {
        List lights = null;
        if (this.bridge != null) {
            try {
                try {
                    lights = this.bridge.getFullConfig().getLights();
                }
                catch (IllegalStateException | UnauthorizedException throwable) {
                    this.lastBridgeConnectionState = false;
                    this.onNotAuthenticated(this.bridge);
                    lights = this.bridge.getFullConfig().getLights();
                }
            }
            catch (Exception e) {
                this.logger.error("Bridge cannot search for new lights.", (Throwable)e);
            }
        }
        return lights;
    }

    public void startSearch() {
        if (this.bridge != null) {
            try {
                this.bridge.startSearch();
            }
            catch (Exception e) {
                this.logger.error("Bridge cannot start search mode", (Throwable)e);
            }
        }
    }

    public void startSearch(List<String> serialNumbers) {
        if (this.bridge != null) {
            try {
                this.bridge.startSearch(serialNumbers);
            }
            catch (Exception e) {
                this.logger.error("Bridge cannot start search mode", (Throwable)e);
            }
        }
    }

    private void notifyLightStatusListeners(FullLight fullLight, String type) {
        block10: for (LightStatusListener lightStatusListener : this.lightStatusListeners) {
            try {
                switch (type) {
                    case "added": {
                        lightStatusListener.onLightAdded(this.bridge, fullLight);
                        continue block10;
                    }
                    case "changed": {
                        lightStatusListener.onLightStateChanged(this.bridge, fullLight);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not notify lightStatusListeners for unknown event type " + type);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
            }
        }
    }

    private boolean isEqual(State state1, State state2) {
        boolean commonStateIsEqual;
        boolean bl = commonStateIsEqual = state1.getAlertMode().equals((Object)state2.getAlertMode()) && state1.isOn() == state2.isOn() && state1.getBrightness() == state2.getBrightness() && state1.getColorTemperature() == state2.getColorTemperature() && state1.getHue() == state2.getHue() && state1.getSaturation() == state2.getSaturation() && state1.isReachable() == state2.isReachable();
        if (!commonStateIsEqual) {
            return false;
        }
        boolean colorModeIsEqual = true;
        boolean effectIsEqual = true;
        try {
            colorModeIsEqual = state1.getColorMode().equals((Object)state2.getColorMode());
        }
        catch (NullPointerException nullPointerException) {
            this.logger.trace("Light does not support color mode.");
        }
        try {
            effectIsEqual = state1.getEffect().equals((Object)state2.getEffect());
        }
        catch (NullPointerException nullPointerException) {
            this.logger.trace("Light does not support effect.");
        }
        return colorModeIsEqual && effectIsEqual;
    }
}

