/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MACAddress {
    private Logger logger = LoggerFactory.getLogger(MACAddress.class);
    private ByteBuffer bytes;
    private String hex;

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public String getHex() {
        return this.hex;
    }

    public MACAddress(ByteBuffer bytes) {
        this.bytes = bytes;
        this.createHex();
    }

    public MACAddress(String string, boolean isHex) {
        if (!isHex) {
            this.bytes = ByteBuffer.wrap(string.getBytes());
            this.createHex();
        } else {
            this.bytes = ByteBuffer.wrap(DatatypeConverter.parseHexBinary((String)string));
            try {
                this.formatHex(string, 2, ":");
            }
            catch (IOException e) {
                this.logger.error("An exception occured while formatting an HEX string : '{}'", (Object)e.getMessage());
            }
        }
    }

    public MACAddress() {
        this(ByteBuffer.allocate(6));
    }

    private void createHex() {
        this.bytes.rewind();
        LinkedList<String> byteStrings = new LinkedList<String>();
        while (this.bytes.hasRemaining()) {
            byteStrings.add(String.format("%02X", this.bytes.get()));
        }
        this.hex = StringUtils.join(byteStrings, (char)':');
        this.bytes.rewind();
    }

    public String getAsLabel() {
        this.bytes.rewind();
        StringBuilder hex = new StringBuilder();
        while (this.bytes.hasRemaining()) {
            hex.append(String.format("%02X", this.bytes.get()));
        }
        this.bytes.rewind();
        return hex.toString();
    }

    private void formatHex(String original, int length, String separator) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(original.getBytes());
        byte[] buffer = new byte[length];
        String result = "";
        while (bis.read(buffer) > 0) {
            byte[] byArray = buffer;
            int n = buffer.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                result = String.valueOf(result) + (char)b;
                ++n2;
            }
            Arrays.fill(buffer, (byte)0);
            result = String.valueOf(result) + separator;
        }
        this.hex = StringUtils.left((String)result, (int)(result.length() - 1));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.hex);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MACAddress other = (MACAddress)obj;
        return this.hex.equalsIgnoreCase(other.hex);
    }
}

