/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.ByteField;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class SetColorRequest
extends Packet {
    public static final int TYPE = 102;
    public static final Field<ByteBuffer> FIELD_STREAM = new ByteField(1);
    public static final Field<Integer> FIELD_HUE = new UInt16Field().little();
    public static final Field<Integer> FIELD_SATURATION = new UInt16Field().little();
    public static final Field<Integer> FIELD_BRIGHTNESS = new UInt16Field().little();
    public static final Field<Integer> FIELD_KELVIN = new UInt16Field().little();
    public static final Field<Long> FIELD_FADE_TIME = new UInt32Field().little();
    private ByteBuffer stream = ByteBuffer.allocate(1);
    private int hue;
    private int saturation;
    private int brightness;
    private int kelvin;
    private long fadeTime;

    public ByteBuffer getStream() {
        return this.stream;
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public int getKelvin() {
        return this.kelvin;
    }

    public long getFadeTime() {
        return this.fadeTime;
    }

    public SetColorRequest() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public SetColorRequest(int hue, int saturation, int brightness, int kelvin, long fadeTime) {
        this();
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.kelvin = kelvin;
        this.fadeTime = fadeTime;
    }

    @Override
    public int packetType() {
        return 102;
    }

    @Override
    protected int packetLength() {
        return 13;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.stream = FIELD_STREAM.value(bytes);
        this.hue = FIELD_HUE.value(bytes);
        this.saturation = FIELD_SATURATION.value(bytes);
        this.brightness = FIELD_BRIGHTNESS.value(bytes);
        this.kelvin = FIELD_KELVIN.value(bytes);
        this.fadeTime = FIELD_FADE_TIME.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_STREAM.bytes(this.stream)).put(FIELD_HUE.bytes(this.hue)).put(FIELD_SATURATION.bytes(this.saturation)).put(FIELD_BRIGHTNESS.bytes(this.brightness)).put(FIELD_KELVIN.bytes(this.kelvin)).put(FIELD_FADE_TIME.bytes(this.fadeTime));
    }

    @Override
    public int[] expectedResponses() {
        return new int[]{107};
    }
}

