/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class SetDimAbsoluteRequest
extends Packet {
    public static final int TYPE = 104;
    public static final Field<Integer> FIELD_DIM = new UInt16Field().little();
    public static final Field<Long> FIELD_DURATION = new UInt32Field().little();
    private int dim;
    private long duration;

    public int getDim() {
        return this.dim;
    }

    public long getDuration() {
        return this.duration;
    }

    public SetDimAbsoluteRequest() {
    }

    public SetDimAbsoluteRequest(int dim, long duration) {
        this.dim = dim;
        this.duration = duration;
    }

    @Override
    public int packetType() {
        return 104;
    }

    @Override
    protected int packetLength() {
        return 6;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.dim = FIELD_DIM.value(bytes);
        this.duration = FIELD_DURATION.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_DIM.bytes(this.dim)).put(FIELD_DURATION.bytes(this.duration));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

