/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt64Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateInfoResponse
extends Packet {
    public static final int TYPE = 35;
    public static final Field<Long> FIELD_TIME = new UInt64Field().little();
    public static final Field<Long> FIELD_UPTIME = new UInt64Field().little();
    public static final Field<Long> FIELD_DOWNTIME = new UInt64Field().little();
    private long time;
    private long uptime;
    private long downtime;

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public long getDowntime() {
        return this.downtime;
    }

    public void setDowntime(long downtime) {
        this.downtime = downtime;
    }

    public StateInfoResponse() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 35;
    }

    @Override
    protected int packetLength() {
        return 24;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.time = FIELD_TIME.value(bytes);
        this.uptime = FIELD_UPTIME.value(bytes);
        this.downtime = FIELD_DOWNTIME.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_TIME.bytes(this.time)).put(FIELD_UPTIME.bytes(this.uptime)).put(FIELD_DOWNTIME.bytes(this.downtime));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

