/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.ntp.handler;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpHandler
extends BaseThingHandler {
    private Logger logger = LoggerFactory.getLogger(NtpHandler.class);
    private static final int NTP_TIMEOUT = 5000;
    private final DateFormat SDF = SimpleDateFormat.getDateTimeInstance(0, 0);
    private final LocaleProvider localeProvider;
    ScheduledFuture<?> refreshJob;
    private String hostname;
    private BigDecimal refreshInterval;
    private BigDecimal refreshNtp = new BigDecimal(0);
    private TimeZone timeZone;
    private Locale locale;
    private int refreshNtpCount = 0;
    private long timeOffset;
    private ChannelUID dateTimeChannelUID;

    public NtpHandler(Thing thing, LocaleProvider localeProvider) {
        super(thing);
        this.localeProvider = localeProvider;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.refreshNtpCount = 0;
        this.refreshTimeDate();
    }

    public void initialize() {
        try {
            this.logger.debug("Initializing NTP handler for '{}'.", (Object)this.getThing().getUID().toString());
            Configuration config = this.getThing().getConfiguration();
            this.hostname = (String)config.get("hostname");
            this.refreshInterval = (BigDecimal)config.get("refreshInterval");
            this.refreshNtp = (BigDecimal)config.get("refreshNtp");
            this.refreshNtpCount = 0;
            try {
                this.timeZone = TimeZone.getTimeZone((String)config.get("timeZone"));
            }
            catch (Exception exception) {
                this.timeZone = TimeZone.getDefault();
                this.logger.debug("{} using default TZ: {}", (Object)this.getThing().getUID().toString(), (Object)this.timeZone);
            }
            try {
                String localeString = (String)config.get("locale");
                this.locale = new Locale(localeString);
            }
            catch (Exception exception) {
                this.locale = this.localeProvider.getLocale();
                this.logger.debug("{} using default locale: {}", (Object)this.getThing().getUID().toString(), (Object)this.locale);
            }
            this.dateTimeChannelUID = new ChannelUID(this.getThing().getUID(), "dateTime");
            this.logger.debug("Initialized NTP handler '{}' with configuration: host '{}', refresh interval {}, timezone {}, locale {}.", new Object[]{this.getThing().getUID().toString(), this.hostname, this.refreshInterval, this.timeZone, this.locale});
            this.startAutomaticRefresh();
        }
        catch (Exception ex) {
            String msg = "Error occured while initializing NTP handler: " + ex.getMessage();
            this.logger.error(msg, (Throwable)ex);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, msg);
        }
    }

    public void dispose() {
        this.refreshJob.cancel(true);
        super.dispose();
    }

    private void startAutomaticRefresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    NtpHandler.this.refreshTimeDate();
                }
                catch (Exception e) {
                    NtpHandler.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        this.refreshJob = this.scheduler.scheduleAtFixedRate(runnable, 0L, this.refreshInterval.intValue(), TimeUnit.SECONDS);
    }

    private synchronized void refreshTimeDate() {
        long networkTimeInMillis;
        if (this.refreshNtpCount <= 0) {
            networkTimeInMillis = this.getTime(this.hostname);
            this.timeOffset = networkTimeInMillis - System.currentTimeMillis();
            this.logger.debug("{} delta system time: {}", (Object)this.getThing().getUID().toString(), (Object)this.timeOffset);
            this.refreshNtpCount = this.refreshNtp.intValue();
        } else {
            networkTimeInMillis = System.currentTimeMillis() + this.timeOffset;
            --this.refreshNtpCount;
        }
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTimeInMillis(networkTimeInMillis);
        this.updateState(this.dateTimeChannelUID, (State)new DateTimeType(calendar));
    }

    public long getTime(String hostname) {
        try {
            NTPUDPClient timeClient = new NTPUDPClient();
            timeClient.setDefaultTimeout(5000);
            InetAddress inetAddress = InetAddress.getByName(hostname);
            TimeInfo timeInfo = timeClient.getTime(inetAddress);
            this.logger.debug("{} Got time update from: {}", new Object[]{this.getThing().getUID().toString(), hostname, this.SDF.format(new Date(timeInfo.getReturnTime()))});
            this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
            return timeInfo.getReturnTime();
        }
        catch (UnknownHostException unknownHostException) {
            String msg = String.valueOf(this.getThing().getUID().toString()) + " the given hostname '" + hostname + "' of the timeserver is unknown -> returning current sytem time instead.";
            this.logger.warn(msg);
            this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.COMMUNICATION_ERROR, msg);
        }
        catch (IOException iOException) {
            String msg = String.valueOf(this.getThing().getUID().toString()) + " couldn't establish network connection [host '" + hostname + "'] -> returning current sytem time instead.";
            this.logger.warn(msg);
            this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.COMMUNICATION_ERROR, msg);
        }
        return System.currentTimeMillis();
    }

    public void channelLinked(ChannelUID channelUID) {
        this.refreshTimeDate();
    }
}

