/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.yahooweather.handler;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.ConfigStatusThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherHandler
extends ConfigStatusThingHandler {
    private static final String LOCATION_NOT_FOUND = "yahooweather.configparam.location.notfound";
    private static final String LOCATION_PARAM = "location";
    private final Logger logger = LoggerFactory.getLogger(YahooWeatherHandler.class);
    private BigDecimal location;
    private BigDecimal refresh;
    private String weatherData = null;
    ScheduledFuture<?> refreshJob;

    public YahooWeatherHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.logger.debug("Initializing YahooWeather handler.");
        super.initialize();
        Configuration config = this.getThing().getConfiguration();
        this.location = (BigDecimal)config.get(LOCATION_PARAM);
        try {
            this.refresh = (BigDecimal)config.get("refresh");
        }
        catch (Exception e) {
            this.logger.debug("Cannot set refresh parameter.", (Throwable)e);
        }
        if (this.refresh == null) {
            this.refresh = new BigDecimal(60);
        }
        this.startAutomaticRefresh();
    }

    public void dispose() {
        this.refreshJob.cancel(true);
    }

    private void startAutomaticRefresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean success = YahooWeatherHandler.this.updateWeatherData();
                    if (success) {
                        YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "temperature"), YahooWeatherHandler.this.getTemperature());
                        YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "humidity"), YahooWeatherHandler.this.getHumidity());
                        YahooWeatherHandler.this.updateState(new ChannelUID(YahooWeatherHandler.this.getThing().getUID(), "pressure"), YahooWeatherHandler.this.getPressure());
                    }
                }
                catch (Exception e) {
                    YahooWeatherHandler.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        this.refreshJob = this.scheduler.scheduleAtFixedRate(runnable, 0L, this.refresh.intValue(), TimeUnit.SECONDS);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block14: {
            block13: {
                if (!(command instanceof RefreshType)) break block13;
                boolean success = this.updateWeatherData();
                if (!success) break block14;
                switch (channelUID.getId()) {
                    case "temperature": {
                        this.updateState(channelUID, this.getTemperature());
                        break;
                    }
                    case "humidity": {
                        this.updateState(channelUID, this.getHumidity());
                        break;
                    }
                    case "pressure": {
                        this.updateState(channelUID, this.getPressure());
                        break;
                    }
                    default: {
                        this.logger.debug("Command received for an unknown channel: {}", (Object)channelUID.getId());
                        break;
                    }
                }
                break block14;
            }
            this.logger.debug("Command {} is not supported for channel: {}", (Object)command, (Object)channelUID.getId());
        }
    }

    public Collection<ConfigStatusMessage> getConfigStatus() {
        ArrayList<ConfigStatusMessage> configStatus = new ArrayList<ConfigStatusMessage>();
        try {
            String weatherData = this.getWeatherData();
            String result = StringUtils.substringBetween((String)weatherData, (String)"<item><title>", (String)"</title>");
            if ("City not found".equals(result)) {
                configStatus.add(ConfigStatusMessage.Builder.error((String)LOCATION_PARAM).withMessageKey(LOCATION_NOT_FOUND).withArguments(new Object[]{this.location}).build());
            }
        }
        catch (IOException e) {
            this.logger.debug("Communication error occurred while getting Yahoo weather information.", (Throwable)e);
        }
        return configStatus;
    }

    private synchronized boolean updateWeatherData() {
        try {
            this.weatherData = this.getWeatherData();
            if (this.weatherData != null) {
                this.updateStatus(ThingStatus.ONLINE);
                return true;
            }
        }
        catch (IOException e) {
            this.logger.warn("Error accessing Yahoo weather: {}", (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, e.getMessage());
        }
        return false;
    }

    private String getWeatherData() throws IOException {
        String urlString = "https://query.yahooapis.com/v1/public/yql?format=json&q=SELECT%20*%20FROM%20weather.forecast%20WHERE%20u=%27c%27%20AND%20woeid%20=%20%27" + this.location + "%27";
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            return IOUtils.toString((InputStream)connection.getInputStream());
        }
        catch (MalformedURLException e) {
            this.logger.debug("Constructed url '{}' is not valid: {}", (Object)urlString, (Object)e.getMessage());
            return null;
        }
    }

    private State getHumidity() {
        if (this.weatherData != null) {
            String humidity = StringUtils.substringAfter((String)this.weatherData, (String)"atmosphere");
            if ((humidity = StringUtils.substringBetween((String)humidity, (String)"humidity\":\"", (String)"\"")) != null) {
                return new DecimalType(humidity);
            }
        }
        return UnDefType.UNDEF;
    }

    private State getPressure() {
        if (this.weatherData != null) {
            String pressure = StringUtils.substringAfter((String)this.weatherData, (String)"atmosphere");
            if ((pressure = StringUtils.substringBetween((String)pressure, (String)"pressure\":\"", (String)"\"")) != null) {
                return new DecimalType(pressure);
            }
        }
        return UnDefType.UNDEF;
    }

    private State getTemperature() {
        if (this.weatherData != null) {
            String temp = StringUtils.substringAfter((String)this.weatherData, (String)"condition");
            if ((temp = StringUtils.substringBetween((String)temp, (String)"temp\":\"", (String)"\"")) != null) {
                return new DecimalType(temp);
            }
        }
        return UnDefType.UNDEF;
    }
}

