/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.normalization;

import org.eclipse.smarthome.config.core.normalization.AbstractNormalizer;

final class BooleanNormalizer
extends AbstractNormalizer {
    BooleanNormalizer() {
    }

    @Override
    public Object doNormalize(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Byte) {
            return this.handleNumeric(((Byte)value).longValue());
        }
        if (value instanceof Integer) {
            return this.handleNumeric(((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return this.handleNumeric((Long)value);
        }
        String s = value.toString();
        if ("true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "off".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s)) {
            return false;
        }
        this.logger.trace("Class \"{}\" cannot be converted to boolean.", (Object)value.getClass().getName());
        return value;
    }

    private Object handleNumeric(long numeric) {
        if (numeric == 1L) {
            return true;
        }
        if (numeric == 0L) {
            return false;
        }
        this.logger.trace("\"{}\" cannot be interpreted as a boolean.", (Object)numeric);
        return numeric;
    }
}

