/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import com.google.common.collect.HashMultimap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryServiceRegistryImpl
implements DiscoveryServiceRegistry,
DiscoveryListener {
    private HashMultimap<DiscoveryService, DiscoveryResult> cachedResults = HashMultimap.create();
    private List<DiscoveryService> discoveryServices = new CopyOnWriteArrayList<DiscoveryService>();
    private Set<DiscoveryListener> listeners = new CopyOnWriteArraySet<DiscoveryListener>();
    private final Logger logger = LoggerFactory.getLogger(DiscoveryServiceRegistryImpl.class);

    @Override
    public boolean abortScan(ThingTypeUID thingTypeUID) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.abortScans(discoveryServicesForThingType);
    }

    @Override
    public boolean abortScan(String bindingId) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding '{}' found!", (Object)bindingId);
            return false;
        }
        return this.abortScans(discoveryServicesForBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            Set entries = this.cachedResults.entries();
            for (Map.Entry entry : entries) {
                listener.thingDiscovered((DiscoveryService)entry.getKey(), (DiscoveryResult)entry.getValue());
            }
        }
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean startScan(ThingTypeUID thingTypeUID, ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.startScans(discoveryServicesForThingType, listener);
    }

    @Override
    public boolean startScan(String bindingId, ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding id '{}' found!", (Object)bindingId);
            return false;
        }
        return this.startScans(discoveryServicesForBinding, listener);
    }

    @Override
    public boolean supportsDiscovery(ThingTypeUID thingTypeUID) {
        return !this.getDiscoveryServices(thingTypeUID).isEmpty();
    }

    @Override
    public boolean supportsDiscovery(String bindingId) {
        return !this.getDiscoveryServices(bindingId).isEmpty();
    }

    @Override
    public List<ThingTypeUID> getSupportedThingTypes() {
        ArrayList<ThingTypeUID> thingTypeUIDs = new ArrayList<ThingTypeUID>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            thingTypeUIDs.addAll(discoveryService.getSupportedThingTypes());
        }
        return thingTypeUIDs;
    }

    @Override
    public List<String> getSupportedBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : supportedThingTypes) {
                bindings.add(thingTypeUID.getBindingId());
            }
        }
        return bindings;
    }

    @Override
    public synchronized void removeDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void thingDiscovered(final DiscoveryService source, final DiscoveryResult result) {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            this.cachedResults.put((Object)source, (Object)result);
        }
        for (final DiscoveryListener listener : this.listeners) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        listener.thingDiscovered(source, result);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener " + listener.getClass().getName() + " on Thing discovered event!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void thingRemoved(final DiscoveryService source, final ThingUID thingUID) {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            this.cachedResults.remove((Object)source, (Object)thingUID);
        }
        for (final DiscoveryListener listener : this.listeners) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        listener.thingRemoved(source, thingUID);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '" + listener.getClass().getName() + "' on Thing removed event!", (Throwable)ex);
            }
        }
    }

    @Override
    public Collection<ThingUID> removeOlderResults(final DiscoveryService source, final long timestamp, final Collection<ThingTypeUID> thingTypeUIDs) {
        HashSet<ThingUID> removedResults = new HashSet<ThingUID>();
        for (final DiscoveryListener listener : this.listeners) {
            try {
                Collection<ThingUID> olderResults = AccessController.doPrivileged(new PrivilegedAction<Collection<ThingUID>>(){

                    @Override
                    public Collection<ThingUID> run() {
                        return listener.removeOlderResults(source, timestamp, thingTypeUIDs);
                    }
                });
                if (olderResults == null) continue;
                removedResults.addAll(olderResults);
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '" + listener.getClass().getName() + "' on all things removed event!", (Throwable)ex);
            }
        }
        return removedResults;
    }

    private boolean abortScans(Set<DiscoveryService> discoveryServices) {
        boolean allServicesAborted = true;
        for (DiscoveryService discoveryService : discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            try {
                this.logger.debug("Abort scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getName());
                discoveryService.abortScan();
                this.logger.debug("Scan for thing types '{}' aborted on '{}'.", supportedThingTypes, (Object)discoveryService.getClass().getName());
            }
            catch (Exception ex) {
                this.logger.error("Cannot abort scan for thing types '" + supportedThingTypes + "' on '" + discoveryService.getClass().getName() + "'!", (Throwable)ex);
                allServicesAborted = false;
            }
        }
        return allServicesAborted;
    }

    private boolean startScans(Set<DiscoveryService> discoveryServices, ScanListener listener) {
        boolean atLeastOneDiscoveryServiceHasBeenStarted = false;
        if (discoveryServices.size() > 1) {
            this.logger.debug("Trying to start {} scans with an aggregating listener.", (Object)discoveryServices.size());
            AggregatingScanListener aggregatingScanListener = new AggregatingScanListener(discoveryServices.size(), listener);
            for (DiscoveryService discoveryService : discoveryServices) {
                if (this.startScan(discoveryService, (ScanListener)aggregatingScanListener)) {
                    atLeastOneDiscoveryServiceHasBeenStarted = true;
                    continue;
                }
                this.logger.debug("Reducing number of discovery services in aggregating listener, because discovery service failed to start scan.");
                aggregatingScanListener.reduceNumberOfDiscoveryServices();
            }
        } else if (this.startScan(discoveryServices.iterator().next(), listener)) {
            atLeastOneDiscoveryServiceHasBeenStarted = true;
        }
        return atLeastOneDiscoveryServiceHasBeenStarted;
    }

    private boolean startScan(DiscoveryService discoveryService, ScanListener listener) {
        Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
        try {
            this.logger.debug("Triggering scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getSimpleName());
            discoveryService.startScan(listener);
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Cannot trigger scan for thing types '" + supportedThingTypes + "' on '" + discoveryService.getClass().getSimpleName() + "'!", (Throwable)ex);
            return false;
        }
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(ThingTypeUID thingTypeUID) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        if (thingTypeUID != null) {
            for (DiscoveryService discoveryService : this.discoveryServices) {
                Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
                if (!discoveryThingTypes.contains(thingTypeUID)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(String bindingId) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : discoveryThingTypes) {
                if (!thingTypeUID.getBindingId().equals(bindingId)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    protected void addDiscoveryService(DiscoveryService discoveryService) {
        discoveryService.addDiscoveryListener(this);
        this.discoveryServices.add(discoveryService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryServices.remove(discoveryService);
        discoveryService.removeDiscoveryListener(this);
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            this.cachedResults.removeAll((Object)discoveryService);
        }
    }

    protected void deactivate() {
        this.discoveryServices.clear();
        this.listeners.clear();
        this.cachedResults.clear();
    }

    private final class AggregatingScanListener
    implements ScanListener {
        private final ScanListener listener;
        private int finishedDiscoveryServices = 0;
        private boolean errorOccured = false;
        private int numberOfDiscoveryServices;

        private AggregatingScanListener(int numberOfDiscoveryServices, ScanListener listener) {
            this.numberOfDiscoveryServices = numberOfDiscoveryServices;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onFinished() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                ++this.finishedDiscoveryServices;
                DiscoveryServiceRegistryImpl.this.logger.debug("Finished {} of {} discovery services.", (Object)this.finishedDiscoveryServices, (Object)this.numberOfDiscoveryServices);
                if (!this.errorOccured && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onErrorOccurred(Exception exception) {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                if (!this.errorOccured) {
                    if (this.listener != null) {
                        this.listener.onErrorOccurred(exception);
                    }
                    this.errorOccured = true;
                } else {
                    DiscoveryServiceRegistryImpl.this.logger.warn("Error occured while executing discovery service: " + exception.getMessage(), (Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduceNumberOfDiscoveryServices() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                --this.numberOfDiscoveryServices;
                if (!this.errorOccured && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }
    }
}

