/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.UpnpService;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpDiscoveryService
extends AbstractDiscoveryService
implements RegistryListener {
    private final Logger logger = LoggerFactory.getLogger(UpnpDiscoveryService.class);
    private Set<UpnpDiscoveryParticipant> participants = new CopyOnWriteArraySet<UpnpDiscoveryParticipant>();
    private UpnpService upnpService;

    public UpnpDiscoveryService() {
        super(5);
    }

    @Override
    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
        this.startScan();
    }

    protected void setUpnpService(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    protected void unsetUpnpService(UpnpService upnpService) {
        this.upnpService = null;
    }

    protected void addUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.add(participant);
        if (this.upnpService != null) {
            Collection devices = this.upnpService.getRegistry().getRemoteDevices();
            for (RemoteDevice device : devices) {
                participant.createResult(device);
            }
        }
    }

    protected void removeUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (UpnpDiscoveryParticipant participant : this.participants) {
            supportedThingTypes.addAll(participant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    @Override
    protected void startBackgroundDiscovery() {
        this.upnpService.getRegistry().addListener((RegistryListener)this);
    }

    @Override
    protected void stopBackgroundDiscovery() {
        this.upnpService.getRegistry().removeListener((RegistryListener)this);
    }

    @Override
    protected void startScan() {
        for (RemoteDevice device : this.upnpService.getRegistry().getRemoteDevices()) {
            this.remoteDeviceAdded(this.upnpService.getRegistry(), device);
        }
        this.upnpService.getRegistry().addListener((RegistryListener)this);
        this.upnpService.getControlPoint().search();
    }

    @Override
    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
        if (!this.isBackgroundDiscoveryEnabled()) {
            this.upnpService.getRegistry().removeListener((RegistryListener)this);
        }
    }

    public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
        for (UpnpDiscoveryParticipant participant : this.participants) {
            try {
                DiscoveryResult result = participant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
        for (UpnpDiscoveryParticipant participant : this.participants) {
            try {
                ThingUID thingUID = participant.getThingUID(device);
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
    }

    public void localDeviceAdded(Registry registry, LocalDevice device) {
    }

    public void localDeviceRemoved(Registry registry, LocalDevice device) {
    }

    public void beforeShutdown(Registry registry) {
    }

    public void afterShutdown() {
    }

    public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
    }
}

