/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.i18n.ConfigDescriptionGroupI18nUtil;
import org.eclipse.smarthome.config.core.i18n.ConfigDescriptionI18nUtil;
import org.eclipse.smarthome.core.common.osgi.ServiceBinder;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.osgi.framework.Bundle;

public class XmlConfigDescriptionProvider
implements ConfigDescriptionProvider {
    private Map<Bundle, List<ConfigDescription>> bundleConfigDescriptionsMap = new HashMap<Bundle, List<ConfigDescription>>(10);
    private ConfigDescriptionI18nUtil configDescriptionParamI18nUtil;
    private ConfigDescriptionGroupI18nUtil configDescriptionGroupI18nUtil;

    private List<ConfigDescription> acquireConfigDescriptions(Bundle bundle) {
        if (bundle != null) {
            List<ConfigDescription> configDescriptions = this.bundleConfigDescriptionsMap.get(bundle);
            if (configDescriptions == null) {
                configDescriptions = new ArrayList<ConfigDescription>(10);
                this.bundleConfigDescriptionsMap.put(bundle, configDescriptions);
            }
            return configDescriptions;
        }
        return null;
    }

    public synchronized void addConfigDescription(Bundle bundle, ConfigDescription configDescription) {
        List<ConfigDescription> configDescriptionList;
        if (configDescription != null && (configDescriptionList = this.acquireConfigDescriptions(bundle)) != null) {
            configDescriptionList.add(configDescription);
        }
    }

    public synchronized void addConfigDescriptions(Bundle bundle, List<ConfigDescription> configDescriptions) {
        List<ConfigDescription> currentConfigDescriptionList;
        if (configDescriptions != null && configDescriptions.size() > 0 && (currentConfigDescriptionList = this.acquireConfigDescriptions(bundle)) != null) {
            for (ConfigDescription configDescription : configDescriptions) {
                currentConfigDescriptionList.add(configDescription);
            }
        }
    }

    public synchronized void removeAllConfigDescriptions(Bundle bundle) {
        List<ConfigDescription> configDescriptions;
        if (bundle != null && (configDescriptions = this.bundleConfigDescriptionsMap.get(bundle)) != null) {
            this.bundleConfigDescriptionsMap.remove(bundle);
        }
    }

    public synchronized Collection<ConfigDescription> getConfigDescriptions(Locale locale) {
        ArrayList<ConfigDescription> allConfigDescriptions = new ArrayList<ConfigDescription>(10);
        Set<Map.Entry<Bundle, List<ConfigDescription>>> configDescriptionsList = this.bundleConfigDescriptionsMap.entrySet();
        if (configDescriptionsList != null) {
            for (Map.Entry entry : configDescriptionsList) {
                for (ConfigDescription configDescription : (List)entry.getValue()) {
                    ConfigDescription localizedConfigDescription = this.getLocalizedConfigDescription((Bundle)entry.getKey(), configDescription, locale);
                    allConfigDescriptions.add(localizedConfigDescription);
                }
            }
        }
        return allConfigDescriptions;
    }

    public synchronized ConfigDescription getConfigDescription(URI uri, Locale locale) {
        Set<Map.Entry<Bundle, List<ConfigDescription>>> configDescriptionsList = this.bundleConfigDescriptionsMap.entrySet();
        if (configDescriptionsList != null) {
            for (Map.Entry entry : configDescriptionsList) {
                for (ConfigDescription configDescription : (List)entry.getValue()) {
                    if (!configDescription.getURI().equals(uri)) continue;
                    return this.getLocalizedConfigDescription((Bundle)entry.getKey(), configDescription, locale);
                }
            }
        }
        return null;
    }

    @ServiceBinder.Bind
    public void seI18nProvider(I18nProvider i18nProvider) {
        this.configDescriptionParamI18nUtil = new ConfigDescriptionI18nUtil(i18nProvider);
        this.configDescriptionGroupI18nUtil = new ConfigDescriptionGroupI18nUtil(i18nProvider);
    }

    @ServiceBinder.Unbind
    public void unsetI18nProvider(I18nProvider i18nProvider) {
        this.configDescriptionParamI18nUtil = null;
        this.configDescriptionGroupI18nUtil = null;
    }

    private ConfigDescription getLocalizedConfigDescription(Bundle bundle, ConfigDescription configDescription, Locale locale) {
        if (this.configDescriptionParamI18nUtil != null && this.configDescriptionGroupI18nUtil != null) {
            ArrayList<ConfigDescriptionParameter> localizedConfigDescriptionParameters = new ArrayList<ConfigDescriptionParameter>(configDescription.getParameters().size());
            for (ConfigDescriptionParameter configDescriptionParameter : configDescription.getParameters()) {
                ConfigDescriptionParameter localizedConfigDescriptionParameter = this.getLocalizedConfigDescriptionParameter(bundle, configDescription, configDescriptionParameter, locale);
                localizedConfigDescriptionParameters.add(localizedConfigDescriptionParameter);
            }
            ArrayList<ConfigDescriptionParameterGroup> localizedConfigDescriptionGroups = new ArrayList<ConfigDescriptionParameterGroup>(configDescription.getParameterGroups().size());
            for (ConfigDescriptionParameterGroup configDescriptionParameterGroup : configDescription.getParameterGroups()) {
                ConfigDescriptionParameterGroup localizedConfigDescriptionGroup = this.getLocalizedConfigDescriptionGroup(bundle, configDescription, configDescriptionParameterGroup, locale);
                localizedConfigDescriptionGroups.add(localizedConfigDescriptionGroup);
            }
            return new ConfigDescription(configDescription.getURI(), localizedConfigDescriptionParameters, localizedConfigDescriptionGroups);
        }
        return configDescription;
    }

    private ConfigDescriptionParameter getLocalizedConfigDescriptionParameter(Bundle bundle, ConfigDescription configDescription, ConfigDescriptionParameter parameter, Locale locale) {
        URI configDescriptionURI = configDescription.getURI();
        String parameterName = parameter.getName();
        String label = this.configDescriptionParamI18nUtil.getParameterLabel(bundle, configDescriptionURI, parameterName, parameter.getLabel(), locale);
        String description = this.configDescriptionParamI18nUtil.getParameterDescription(bundle, configDescriptionURI, parameterName, parameter.getDescription(), locale);
        String pattern = this.configDescriptionParamI18nUtil.getParameterPattern(bundle, configDescriptionURI, parameterName, parameter.getPattern(), locale);
        String unitLabel = this.configDescriptionParamI18nUtil.getParameterUnitLabel(bundle, configDescriptionURI, parameterName, parameter.getUnit(), parameter.getUnitLabel(), locale);
        List<ParameterOption> options = this.getLocalizedOptions(parameter.getOptions(), bundle, configDescriptionURI, parameterName, locale);
        ConfigDescriptionParameter localizedParameter = ConfigDescriptionParameterBuilder.create((String)parameterName, (ConfigDescriptionParameter.Type)parameter.getType()).withMinimum(parameter.getMinimum()).withMaximum(parameter.getMaximum()).withStepSize(parameter.getStepSize()).withPattern(pattern).withRequired(Boolean.valueOf(parameter.isRequired())).withReadOnly(parameter.isReadOnly()).withMultiple(parameter.isMultiple()).withContext(parameter.getContext()).withDefault(parameter.getDefault()).withLabel(label).withDescription(description).withOptions(options).withFilterCriteria(parameter.getFilterCriteria()).withGroupName(parameter.getGroupName()).withAdvanced(Boolean.valueOf(parameter.isAdvanced())).withLimitToOptions(Boolean.valueOf(parameter.getLimitToOptions())).withMultipleLimit(parameter.getMultipleLimit()).withUnit(parameter.getUnit()).withUnitLabel(unitLabel).build();
        return localizedParameter;
    }

    private ConfigDescriptionParameterGroup getLocalizedConfigDescriptionGroup(Bundle bundle, ConfigDescription configDescription, ConfigDescriptionParameterGroup group, Locale locale) {
        URI configDescriptionURI = configDescription.getURI();
        String name = group.getName();
        String label = this.configDescriptionGroupI18nUtil.getGroupLabel(bundle, configDescriptionURI, name, group.getLabel(), locale);
        String description = this.configDescriptionGroupI18nUtil.getGroupDescription(bundle, configDescriptionURI, name, group.getDescription(), locale);
        ConfigDescriptionParameterGroup localizedGroup = new ConfigDescriptionParameterGroup(name, group.getContext(), Boolean.valueOf(group.isAdvanced()), label, description);
        return localizedGroup;
    }

    private List<ParameterOption> getLocalizedOptions(List<ParameterOption> originalOptions, Bundle bundle, URI configDescriptionURI, String parameterName, Locale locale) {
        if (originalOptions == null || originalOptions.isEmpty()) {
            return originalOptions;
        }
        ArrayList<ParameterOption> localizedOptions = new ArrayList<ParameterOption>();
        for (ParameterOption option : originalOptions) {
            String localizedLabel = this.configDescriptionParamI18nUtil.getParameterOptionLabel(bundle, configDescriptionURI, parameterName, option.getValue(), option.getLabel(), locale);
            ParameterOption localizedOption = new ParameterOption(option.getValue(), localizedLabel);
            localizedOptions.add(localizedOption);
        }
        return localizedOptions;
    }
}

