/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;

public class ThingStatusInfoBuilder {
    private ThingStatus status;
    private ThingStatusDetail statusDetail;
    private String description;

    private ThingStatusInfoBuilder(ThingStatus status, ThingStatusDetail statusDetail, String description) {
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public static ThingStatusInfoBuilder create(ThingStatus status, ThingStatusDetail statusDetail) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Thing status must not be null");
        }
        if (statusDetail == null) {
            throw new IllegalArgumentException("Thing status detail must not be null");
        }
        return new ThingStatusInfoBuilder(status, statusDetail, null);
    }

    public static ThingStatusInfoBuilder create(ThingStatus status) throws IllegalArgumentException {
        return ThingStatusInfoBuilder.create(status, ThingStatusDetail.NONE);
    }

    public ThingStatusInfoBuilder withDescription(String description) throws IllegalArgumentException {
        this.description = description;
        return this;
    }

    public ThingStatusInfoBuilder withStatusDetail(ThingStatusDetail statusDetail) throws IllegalArgumentException {
        if (statusDetail == null) {
            throw new IllegalArgumentException("Thing status detail must not be null");
        }
        this.statusDetail = statusDetail;
        return this;
    }

    public ThingStatusInfo build() {
        return new ThingStatusInfo(this.status, this.statusDetail, this.description);
    }
}

