/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.config;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="config-descriptions")
@Api(value="config-descriptions")
public class ConfigDescriptionResource
implements RESTResource {
    public static final String PATH_CONFIG_DESCRIPTIONS = "config-descriptions";
    private ConfigDescriptionRegistry configDescriptionRegistry;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available config descriptions.", response=ConfigDescriptionDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Iterable transform = Iterables.transform((Iterable)this.configDescriptionRegistry.getConfigDescriptions(locale), (Function)new ConfigDescriptionConverter());
        return Response.ok((Object)Lists.newArrayList((Iterable)transform)).build();
    }

    @GET
    @Path(value="/{uri}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a config description by URI.", response=ConfigDescriptionDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Invalid URI syntax"), @ApiResponse(code=404, message="Not found")})
    public Response getByURI(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language, @PathParam(value="uri") @ApiParam(value="uri") String uri) {
        Locale locale = LocaleUtil.getLocale((String)language);
        try {
            ConfigDescription configDescription = this.configDescriptionRegistry.getConfigDescription(new URI(uri), locale);
            return configDescription != null ? Response.ok((Object)ConfigDescriptionDTOMapper.map((ConfigDescription)configDescription)).build() : JSONResponse.createErrorResponse((Response.Status)Response.Status.NOT_FOUND, (String)("Configuration not found: " + uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)"Exception getting confinguration description");
        }
    }

    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    private final class ConfigDescriptionConverter
    implements Function<ConfigDescription, ConfigDescriptionDTO> {
        private ConfigDescriptionConverter() {
        }

        public ConfigDescriptionDTO apply(ConfigDescription configDescription) {
            return ConfigDescriptionDTOMapper.map((ConfigDescription)configDescription);
        }
    }
}

