/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationService {
    private ConfigurationAdmin configurationAdmin;

    public org.eclipse.smarthome.config.core.Configuration get(String configId) throws IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration(configId, null);
        Dictionary properties = configuration.getProperties();
        return this.toConfiguration(properties);
    }

    public org.eclipse.smarthome.config.core.Configuration update(String configId, org.eclipse.smarthome.config.core.Configuration newConfiguration) throws IOException {
        return this.update(configId, newConfiguration, false);
    }

    public org.eclipse.smarthome.config.core.Configuration update(String configId, org.eclipse.smarthome.config.core.Configuration newConfiguration, boolean override) throws IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration(configId, null);
        org.eclipse.smarthome.config.core.Configuration oldConfiguration = this.toConfiguration(configuration.getProperties());
        Dictionary<String, Object> properties = this.getProperties(configuration);
        Set configurationParameters = newConfiguration.getProperties().entrySet();
        if (override) {
            Set keySet = oldConfiguration.keySet();
            for (String key : keySet) {
                properties.remove(key);
            }
        }
        for (Map.Entry configurationParameter : configurationParameters) {
            Object value = configurationParameter.getValue();
            if (value == null || value instanceof String || value instanceof Integer || value instanceof Boolean) {
                properties.put((String)configurationParameter.getKey(), value);
                continue;
            }
            properties.put((String)configurationParameter.getKey(), value.toString());
        }
        configuration.update(properties);
        return oldConfiguration;
    }

    public org.eclipse.smarthome.config.core.Configuration delete(String configId) throws IOException {
        Configuration serviceConfiguration = this.configurationAdmin.getConfiguration(configId, null);
        org.eclipse.smarthome.config.core.Configuration oldConfiguration = this.toConfiguration(serviceConfiguration.getProperties());
        serviceConfiguration.delete();
        return oldConfiguration;
    }

    private org.eclipse.smarthome.config.core.Configuration toConfiguration(Dictionary<String, Object> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(dictionary.size());
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.equals("service.pid")) continue;
            properties.put(key, dictionary.get(key));
        }
        return new org.eclipse.smarthome.config.core.Configuration(properties);
    }

    private Dictionary<String, Object> getProperties(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        return properties != null ? properties : new Hashtable();
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

