/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.discovery;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedHashSet;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="discovery")
@Api(value="discovery")
public class DiscoveryResource
implements RESTResource {
    public static final String PATH_DISCOVERY = "discovery";
    private final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);
    private DiscoveryServiceRegistry discoveryServiceRegistry;
    @Context
    private UriInfo uriInfo;

    protected void setDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    protected void unsetDiscoveryServiceRegistry(DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all bindings that support discovery.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getDiscoveryServices() {
        List supportedBindings = this.discoveryServiceRegistry.getSupportedBindings();
        return Response.ok(new LinkedHashSet(supportedBindings)).build();
    }

    @POST
    @Path(value="/bindings/{bindingId}/scan")
    @ApiOperation(value="Starts asynchronous discovery process for a binding.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response scan(final @PathParam(value="bindingId") @ApiParam(value="bindingId") String bindingId) {
        this.discoveryServiceRegistry.startScan(bindingId, new ScanListener(){

            public void onErrorOccurred(Exception exception) {
                DiscoveryResource.this.logger.error("Error occured while scanning for binding '{}': {}", new Object[]{bindingId, exception.getMessage(), exception});
            }

            public void onFinished() {
                DiscoveryResource.this.logger.debug("Scan for binding '{}' successfully finished.", (Object)bindingId);
            }
        });
        return Response.ok().build();
    }
}

