/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.extensions;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.io.rest.core.extensions.ExtensionEvent;

public class ExtensionEventFactory
extends AbstractEventFactory {
    static final String TOPIC_PREFIX = "smarthome/extensions/{id}";
    static final String EXTENSION_INSTALLED_EVENT_TOPIC_POSTFIX = "/installed";
    static final String EXTENSION_UNINSTALLED_EVENT_TOPIC_POSTFIX = "/uninstalled";
    static final String EXTENSION_FAILURE_EVENT_TOPIC_POSTFIX = "/failed";
    static final String EXTENSION_INSTALLED_EVENT_TOPIC = "smarthome/extensions/{id}/installed";
    static final String EXTENSION_UNINSTALLED_EVENT_TOPIC = "smarthome/extensions/{id}/uninstalled";
    static final String EXTENSION_FAILURE_EVENT_TOPIC = "smarthome/extensions/{id}/failed";

    public ExtensionEventFactory() {
        super((Set)Sets.newHashSet((Object[])new String[]{ExtensionEvent.TYPE}));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        if (topic.endsWith(EXTENSION_FAILURE_EVENT_TOPIC_POSTFIX)) {
            String[] properties = (String[])ExtensionEventFactory.deserializePayload((String)payload, String[].class);
            ExtensionEvent event = new ExtensionEvent(topic, payload, properties[0], properties[1]);
            return event;
        }
        String id = (String)ExtensionEventFactory.deserializePayload((String)payload, String.class);
        ExtensionEvent event = new ExtensionEvent(topic, payload, id);
        return event;
    }

    public static ExtensionEvent createExtensionInstalledEvent(String id) {
        String topic = ExtensionEventFactory.buildTopic(EXTENSION_INSTALLED_EVENT_TOPIC, id);
        String payload = ExtensionEventFactory.serializePayload((Object)id);
        return new ExtensionEvent(topic, payload, id);
    }

    public static ExtensionEvent createExtensionUninstalledEvent(String id) {
        String topic = ExtensionEventFactory.buildTopic(EXTENSION_UNINSTALLED_EVENT_TOPIC, id);
        String payload = ExtensionEventFactory.serializePayload((Object)id);
        return new ExtensionEvent(topic, payload, id);
    }

    public static ExtensionEvent createExtensionFailureEvent(String id, String msg) {
        String topic = ExtensionEventFactory.buildTopic(EXTENSION_FAILURE_EVENT_TOPIC, id);
        String[] properties = new String[]{id, msg};
        String payload = ExtensionEventFactory.serializePayload((Object)properties);
        return new ExtensionEvent(topic, payload, id, msg);
    }

    static String buildTopic(String topic, String id) {
        return topic.replace("{id}", id);
    }
}

