/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.extensions;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.extension.Extension;
import org.eclipse.smarthome.core.extension.ExtensionService;
import org.eclipse.smarthome.core.extension.ExtensionType;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.extensions.ExtensionEvent;
import org.eclipse.smarthome.io.rest.core.extensions.ExtensionEventFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="extensions")
@Api(value="extensions")
public class ExtensionResource
implements RESTResource {
    private static final String THREAD_POOL_NAME = "extensionService";
    public static final String PATH_EXTENSIONS = "extensions";
    private final Logger logger = LoggerFactory.getLogger(ExtensionResource.class);
    private ExtensionService extensionService;
    private EventPublisher eventPublisher;
    @Context
    UriInfo uriInfo;

    protected void setExtensionService(ExtensionService featureService) {
        this.extensionService = featureService;
    }

    protected void unsetExtensionService(ExtensionService featureService) {
        this.extensionService = null;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all extensions.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public List<Extension> getExtensions(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = LocaleUtil.getLocale((String)language);
        return this.extensionService.getExtensions(locale);
    }

    @GET
    @Path(value="/types")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all extension types.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public List<ExtensionType> getTypes(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = LocaleUtil.getLocale((String)language);
        return this.extensionService.getTypes(locale);
    }

    @GET
    @Path(value="/{extensionId: [a-zA-Z_0-9-]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension with given ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not found")})
    public Response getById(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        Locale locale = LocaleUtil.getLocale((String)language);
        Extension responseObject = this.extensionService.getExtension(extensionId, locale);
        if (responseObject != null) {
            return Response.ok((Object)responseObject).build();
        }
        return Response.status((int)404).build();
    }

    @POST
    @Path(value="/{extensionId: [a-zA-Z_0-9-]*}/install")
    @ApiOperation(value="Installs the extension with the given ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response installExtension(final @PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ExtensionResource.this.extensionService.install(extensionId);
                    ExtensionResource.this.postInstalledEvent(extensionId);
                }
                catch (Exception e) {
                    ExtensionResource.this.logger.error("Exception while installing extension: {}", (Object)e.getMessage());
                    ExtensionResource.this.postFailureEvent(extensionId, e.getMessage());
                }
            }
        });
        return Response.ok().build();
    }

    @POST
    @Path(value="/{extensionId: [a-zA-Z_0-9-]*}/uninstall")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response uninstallExtension(final @PathParam(value="extensionId") @ApiParam(value="extension ID", required=true) String extensionId) {
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ExtensionResource.this.extensionService.uninstall(extensionId);
                    ExtensionResource.this.postUninstalledEvent(extensionId);
                }
                catch (Exception e) {
                    ExtensionResource.this.logger.error("Exception while uninstalling extension: {}", (Object)e.getMessage());
                    ExtensionResource.this.postFailureEvent(extensionId, e.getMessage());
                }
            }
        });
        return Response.ok().build();
    }

    private void postInstalledEvent(String extensionId) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionInstalledEvent(extensionId);
            this.eventPublisher.post((Event)event);
        }
    }

    private void postUninstalledEvent(String extensionId) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionUninstalledEvent(extensionId);
            this.eventPublisher.post((Event)event);
        }
    }

    private void postFailureEvent(String extensionId, String msg) {
        if (this.eventPublisher != null) {
            ExtensionEvent event = ExtensionEventFactory.createExtensionFailureEvent(extensionId, msg);
            this.eventPublisher.post((Event)event);
        }
    }
}

