/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.persistence;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.persistence.ItemHistoryBean;
import org.eclipse.smarthome.io.rest.core.persistence.ServiceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="persistence")
@Api(value="persistence")
public class PersistenceResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(PersistenceResource.class);
    private final int MILLISECONDS_PER_DAY = 86400000;
    public static final String PATH = "persistence";
    private static Map<String, PersistenceService> persistenceServices = new HashMap<String, PersistenceService>();

    public void addPersistenceService(PersistenceService service) {
        persistenceServices.put(service.getName(), service);
    }

    public void removePersistenceService(PersistenceService service) {
        persistenceServices.remove(service.getName());
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a list of persistence services.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response httpGetPersistenceServices(@Context HttpHeaders headers) {
        List<ServiceBean> responseObject = this.getPersistenceServiceList();
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets item persistence data from the persistence service.", response=ItemHistoryBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Unknown Item or persistence service")})
    public Response httpGetPersistenceItemData(@Context HttpHeaders headers, @ApiParam(value="The item name", required=true) @PathParam(value="itemname") String itemName, @ApiParam(value="Name of the persistence service. If not provided the default service will be used", required=false) @QueryParam(value="servicename") String serviceName, @ApiParam(value="Start time of the data to return. Will default to 1 day before endtime", required=false) @QueryParam(value="starttime") String startTime, @ApiParam(value="End time of the data to return. Will default to current time.", required=false) @QueryParam(value="endtime") String endTime, @ApiParam(value="Page number of data to return. This parameter will enable paging.", required=false) @QueryParam(value="page") int pageNumber, @ApiParam(value="The length of each page.", required=false) @QueryParam(value="pagelength") int pageLength) {
        return this.getItemHistoryBean(serviceName, itemName, startTime, endTime, pageNumber, pageLength);
    }

    private Date convertTime(String sTime) {
        DateTimeType dateTime = new DateTimeType(sTime);
        return dateTime.getCalendar().getTime();
    }

    private Response getItemHistoryBean(String serviceName, String itemName, String timeBegin, String timeEnd, int pageNumber, int pageLength) {
        Date dateTimeBegin;
        long timerStart = System.currentTimeMillis();
        PersistenceService service = null;
        if (serviceName != null) {
            service = persistenceServices.get(serviceName);
        }
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)serviceName);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.CONFLICT, (String)("Persistence service not found: " + serviceName));
        }
        if (!(service instanceof QueryablePersistenceService)) {
            this.logger.debug("Persistence service not queryable '{}'.", (Object)serviceName);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.CONFLICT, (String)("Persistence service not queryable: " + serviceName));
        }
        QueryablePersistenceService qService = (QueryablePersistenceService)service;
        Date dateTimeEnd = dateTimeBegin = new Date();
        if (timeBegin != null) {
            dateTimeBegin = this.convertTime(timeBegin);
        }
        if (timeEnd != null) {
            dateTimeEnd = this.convertTime(timeEnd);
        }
        if (dateTimeEnd.getTime() == 0L) {
            dateTimeEnd = new Date();
        }
        if (dateTimeBegin.getTime() == 0L) {
            dateTimeBegin = new Date(dateTimeEnd.getTime() - 86400000L);
        }
        if (dateTimeBegin.getTime() >= dateTimeEnd.getTime()) {
            dateTimeBegin = new Date(dateTimeEnd.getTime() - 86400000L);
        }
        State state = null;
        Long quantity = 0L;
        ItemHistoryBean bean = new ItemHistoryBean();
        bean.name = itemName;
        FilterCriteria filter = new FilterCriteria();
        filter.setEndDate(dateTimeBegin);
        filter.setItemName(itemName);
        filter.setPageSize(1);
        filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
        Iterable result = qService.query(filter);
        if (result != null && result.iterator().hasNext()) {
            bean.addData(dateTimeBegin.getTime(), ((HistoricItem)result.iterator().next()).getState());
            quantity = quantity + 1L;
        }
        filter.setPageSize(pageLength);
        filter.setPageNumber(pageNumber);
        filter.setBeginDate(dateTimeBegin);
        filter.setEndDate(dateTimeEnd);
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        filter.setPageSize(Integer.MAX_VALUE);
        result = qService.query(filter);
        if (result != null) {
            for (HistoricItem historicItem : result) {
                state = historicItem.getState();
                if (state instanceof OnOffType || state instanceof OpenClosedType) {
                    bean.addData(historicItem.getTimestamp().getTime(), state);
                }
                bean.addData(historicItem.getTimestamp().getTime(), state);
                quantity = quantity + 1L;
            }
            if (state != null) {
                bean.addData(dateTimeEnd.getTime(), state);
                quantity = quantity + 1L;
            }
        }
        bean.datapoints = Long.toString(quantity);
        this.logger.debug("Persistence returned {} rows in {}ms", (Object)bean.datapoints, (Object)(System.currentTimeMillis() - timerStart));
        return JSONResponse.createResponse((Response.Status)Response.Status.OK, (Object)bean, (String)"");
    }

    private List<ServiceBean> getPersistenceServiceList() {
        ArrayList<ServiceBean> beanList = new ArrayList<ServiceBean>();
        for (Map.Entry<String, PersistenceService> service : persistenceServices.entrySet()) {
            ServiceBean serviceBean = new ServiceBean();
            serviceBean.name = service.getKey();
            beanList.add(serviceBean);
        }
        return beanList;
    }
}

