/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal.filter;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CorsFilter
implements ContainerResponseFilter {
    private static final String HTTP_HEAD_METHOD = "HEAD";
    private static final String HTTP_DELETE_METHOD = "DELETE";
    private static final String HTTP_PUT_METHOD = "PUT";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_GET_METHOD = "GET";
    private static final String HTTP_OPTIONS_METHOD = "OPTIONS";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ORIGIN_HEADER = "Origin";
    private static final String VARY_HEADER = "Vary";
    private static final String VARY_HEADER_WILDCARD = "*";
    private static final String HEADERS_SEPARATOR = ",";
    private static final List<String> ACCEPTED_HTTP_METHODS_LIST = Lists.newArrayList((Object[])new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"});
    private static final String ACCEPTED_HTTP_METHODS = Joiner.on((String)",").join(ACCEPTED_HTTP_METHODS_LIST);
    private final transient Logger logger = LoggerFactory.getLogger(CorsFilter.class);
    private boolean isEnabled = false;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.isEnabled && !this.processPreflight(requestContext, responseContext)) {
            this.processRequest(requestContext, responseContext);
        }
    }

    private void processRequest(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String origin;
        if (ACCEPTED_HTTP_METHODS_LIST.contains(requestContext.getMethod()) && !HTTP_OPTIONS_METHOD.equals(requestContext.getMethod()) && StringUtils.isNotBlank((String)(origin = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ORIGIN_HEADER)))) {
            responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)origin);
        }
    }

    private boolean processPreflight(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        boolean isCorsPreflight = false;
        if (HTTP_OPTIONS_METHOD.equals(requestContext.getMethod())) {
            String origin = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ORIGIN_HEADER);
            String realRequestMethod = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ACCESS_CONTROL_REQUEST_METHOD);
            boolean bl = isCorsPreflight = StringUtils.isNotBlank((String)origin) && StringUtils.isNotBlank((String)realRequestMethod);
            if (isCorsPreflight) {
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)origin);
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_METHODS_HEADER, (Object)ACCEPTED_HTTP_METHODS);
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)CONTENT_TYPE_HEADER);
                this.appendVaryHeader(responseContext);
            }
        }
        return isCorsPreflight;
    }

    private String getValue(MultivaluedMap<String, String> headers, String header) {
        List values = (List)headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return ((String)values.get(0)).toString();
    }

    private void appendVaryHeader(ContainerResponseContext responseContext) {
        String varyHeader = this.getValue((MultivaluedMap<String, String>)responseContext.getStringHeaders(), VARY_HEADER);
        if (StringUtils.isBlank((String)varyHeader)) {
            responseContext.getHeaders().add((Object)VARY_HEADER, (Object)ORIGIN_HEADER);
        } else if (!VARY_HEADER_WILDCARD.equals(varyHeader)) {
            responseContext.getHeaders().putSingle((Object)VARY_HEADER, (Object)(String.valueOf(varyHeader) + HEADERS_SEPARATOR + ORIGIN_HEADER));
        }
    }

    protected void activate(Map<String, Object> properties) {
        if (properties != null) {
            String corsPropertyValue = (String)properties.get("enable");
            this.isEnabled = "true".equalsIgnoreCase(corsPropertyValue);
        }
        if (this.isEnabled) {
            this.logger.info("enabled CORS for REST API.");
        }
    }
}

