/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.internal.resources.beans.RootBean;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RootResource {
    private final transient Logger logger = LoggerFactory.getLogger(RootResource.class);
    private List<RESTResource> restResources = new ArrayList<RESTResource>();
    private ConfigurationAdmin configurationAdmin;
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response getRoot(@Context HttpHeaders headers) {
        return Response.ok((Object)this.getRootBean()).build();
    }

    private RootBean getRootBean() {
        RootBean bean = new RootBean();
        for (RESTResource resource : this.restResources) {
            String path = resource.getClass().getAnnotation(Path.class).value();
            bean.links.add(new RootBean.Links(path, this.uriInfo.getBaseUriBuilder().path(path).build(new Object[0]).toASCIIString()));
        }
        return bean;
    }

    public void addRESTResource(RESTResource resource) {
        this.restResources.add(resource);
    }

    public void removeRESTResource(RESTResource resource) {
        this.restResources.remove(resource);
    }

    public void activate() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("com.eclipsesource.jaxrs.connector", null);
            if (configuration != null) {
                String rootAlias;
                Dictionary properties = configuration.getProperties();
                if (properties == null) {
                    properties = new Properties();
                }
                if (!"/rest".equals(rootAlias = (String)properties.get("root"))) {
                    properties.put("root", "/rest");
                    configuration.update(properties);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Could not set REST configuration properties!", (Throwable)e);
        }
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = null;
    }
}

