/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mdns.discovery;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mdns.MDNSClient;
import org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNSDiscoveryService
extends AbstractDiscoveryService
implements ServiceListener {
    private final Logger logger = LoggerFactory.getLogger(MDNSDiscoveryService.class);
    private Set<MDNSDiscoveryParticipant> participants = new CopyOnWriteArraySet<MDNSDiscoveryParticipant>();
    private MDNSClient mdnsClient;

    public MDNSDiscoveryService() {
        super(5);
    }

    public void setMDNSClient(MDNSClient mdnsClient) {
        this.mdnsClient = mdnsClient;
        if (this.isBackgroundDiscoveryEnabled()) {
            for (MDNSDiscoveryParticipant participant : this.participants) {
                mdnsClient.getClient().addServiceListener(participant.getServiceType(), (ServiceListener)this);
            }
        }
    }

    public void unsetMDNSClient(MDNSClient mdnsClient) {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            mdnsClient.getClient().removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
        this.mdnsClient = null;
    }

    protected void startBackgroundDiscovery() {
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                MDNSDiscoveryService.this.startScan();
            }
        }, 0L, TimeUnit.SECONDS);
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.getClient().addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void stopBackgroundDiscovery() {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.getClient().removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void startScan() {
        this.logger.debug("mDNS discovery service started");
        for (MDNSDiscoveryParticipant participant : this.participants) {
            ServiceInfo[] services = this.mdnsClient.getClient().list(participant.getServiceType());
            this.logger.debug(String.valueOf(services.length) + " services found for " + participant.getServiceType());
            ServiceInfo[] serviceInfoArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo service = serviceInfoArray[n2];
                DiscoveryResult result = participant.createResult(service);
                if (result != null) {
                    this.thingDiscovered(result);
                }
                ++n2;
            }
        }
    }

    protected void initializeParticipants() {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            this.mdnsClient.getClient().removeServiceListener(participant.getServiceType(), (ServiceListener)this);
            ServiceInfo[] services = this.mdnsClient.getClient().list(participant.getServiceType());
            this.logger.debug(String.valueOf(services.length) + " services found for " + participant.getServiceType());
            ServiceInfo[] serviceInfoArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInfo service = serviceInfoArray[n2];
                DiscoveryResult result = participant.createResult(service);
                if (result != null) {
                    this.thingDiscovered(result);
                }
                ++n2;
            }
            this.mdnsClient.getClient().addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void addMdnsDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.add(participant);
        if (this.mdnsClient != null && this.isBackgroundDiscoveryEnabled()) {
            this.mdnsClient.getClient().addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void removeMdnsDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.remove(participant);
        if (this.mdnsClient != null) {
            this.mdnsClient.getClient().removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (MDNSDiscoveryParticipant participant : this.participants) {
            supportedThingTypes.addAll(participant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            try {
                DiscoveryResult result = participant.createResult(serviceEvent.getInfo());
                if (result == null) continue;
                this.thingDiscovered(result);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    public void serviceRemoved(ServiceEvent serviceEvent) {
        for (MDNSDiscoveryParticipant participant : this.participants) {
            try {
                ThingUID thingUID = participant.getThingUID(serviceEvent.getInfo());
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    public void serviceResolved(ServiceEvent serviceEvent) {
    }
}

