/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.upnp;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.jupnp.UpnpService;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.UDAServiceId;
import org.jupnp.model.types.UDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpIOServiceImpl
implements UpnpIOService {
    private final Logger logger = LoggerFactory.getLogger(UpnpIOServiceImpl.class);
    private final int DEFAULT_POLLING_INTERVAL = 60;
    private UpnpService upnpService;
    private Map<UpnpIOParticipant, Device> participants = new ConcurrentHashMap<UpnpIOParticipant, Device>(32);
    private Map<UpnpIOParticipant, ScheduledFuture> pollingJobs = new ConcurrentHashMap<UpnpIOParticipant, ScheduledFuture>(32);
    private Map<UpnpIOParticipant, Boolean> currentStates = new ConcurrentHashMap<UpnpIOParticipant, Boolean>(32);
    private Map<Service, UpnpSubscriptionCallback> subscriptionCallbacks = new ConcurrentHashMap<Service, UpnpSubscriptionCallback>(32);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);

    public void activate() {
        this.logger.debug("Starting UPnP IO service...");
    }

    public void deactivate() {
        this.logger.debug("Stopping UPnP IO service...");
    }

    protected void setUpnpService(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    protected void unsetUpnpService(UpnpService upnpService) {
        this.upnpService = null;
    }

    @Override
    public void addSubscription(UpnpIOParticipant participant, String serviceID, int duration) {
        if (participant != null && serviceID != null) {
            this.registerParticipant(participant);
            Device device = this.participants.get(participant);
            if (device != null) {
                Service subService = this.searchSubService(serviceID, device);
                if (subService != null) {
                    this.logger.trace("Setting up an UPNP service subscription '{}' for particpant '{}'", (Object)serviceID, (Object)participant.getUDN());
                    UpnpSubscriptionCallback callback = new UpnpSubscriptionCallback(subService, duration);
                    this.subscriptionCallbacks.put(subService, callback);
                    this.upnpService.getControlPoint().execute((SubscriptionCallback)callback);
                } else {
                    this.logger.trace("Could not find service '{}' for device '{}'", (Object)serviceID, (Object)device.getIdentity().getUdn());
                }
            } else {
                this.logger.trace("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
    }

    private Service searchSubService(String serviceID, Device device) {
        Device[] embedded;
        Service subService = this.findService(device, serviceID);
        if (subService == null && (embedded = device.getEmbeddedDevices()) != null) {
            Device[] deviceArray = embedded;
            int n = embedded.length;
            int n2 = 0;
            while (n2 < n) {
                Device aDevice = deviceArray[n2];
                subService = this.findService(aDevice, serviceID);
                if (subService != null) break;
                ++n2;
            }
        }
        return subService;
    }

    @Override
    public void removeSubscription(UpnpIOParticipant participant, String serviceID) {
        if (participant != null && serviceID != null) {
            Device device = this.participants.get(participant);
            if (device != null) {
                Service subService = this.searchSubService(serviceID, device);
                if (subService != null) {
                    this.logger.trace("Removing an UPNP service subscription '{}' for particpant '{}'", (Object)serviceID, (Object)participant.getUDN());
                    UpnpSubscriptionCallback callback = this.subscriptionCallbacks.get(subService);
                    if (callback != null) {
                        callback.end();
                    }
                    this.subscriptionCallbacks.remove(subService);
                } else {
                    this.logger.trace("Could not find service '{}' for device '{}'", (Object)serviceID, (Object)device.getIdentity().getUdn());
                }
            } else {
                this.logger.trace("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
    }

    @Override
    public Map<String, String> invokeAction(UpnpIOParticipant participant, String serviceID, String actionID, Map<String, String> inputs) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (serviceID != null && actionID != null && participant != null) {
            this.registerParticipant(participant);
            Device device = this.participants.get(participant);
            if (device != null) {
                Service service = this.findService(device, serviceID);
                if (service != null) {
                    Action action = service.getAction(actionID);
                    if (action != null) {
                        ActionInvocation invocation = new ActionInvocation(action);
                        if (invocation != null) {
                            Map result;
                            if (inputs != null) {
                                for (String variable : inputs.keySet()) {
                                    invocation.setInput(variable, (Object)inputs.get(variable));
                                }
                            }
                            this.logger.debug("Invoking Action '{}' of service '{}' for participant '{}'", new Object[]{actionID, serviceID, participant.getUDN()});
                            new ActionCallback.Default(invocation, this.upnpService.getControlPoint()).run();
                            ActionException anException = invocation.getFailure();
                            if (anException != null && anException.getMessage() != null) {
                                this.logger.debug(anException.getMessage());
                            }
                            if ((result = invocation.getOutputMap()) != null) {
                                for (String variable : result.keySet()) {
                                    ActionArgumentValue newArgument;
                                    try {
                                        newArgument = (ActionArgumentValue)result.get(variable);
                                    }
                                    catch (Exception ex) {
                                        this.logger.debug("An exception '{}' occurred, cannot get argument for variable '{}'", (Object)ex.getMessage(), (Object)variable);
                                        continue;
                                    }
                                    try {
                                        if (newArgument.getValue() == null) continue;
                                        resultMap.put(variable, newArgument.getValue().toString());
                                    }
                                    catch (Exception ex) {
                                        this.logger.debug("An exception '{}' occurred processing ActionArgumentValue '{}' with value '{}'", new Object[]{ex.getMessage(), newArgument.getArgument().getName(), newArgument.getValue()});
                                    }
                                }
                            }
                        }
                    } else {
                        this.logger.debug("Could not find action '{}' for participant '{}'", (Object)actionID, (Object)participant.getUDN());
                    }
                } else {
                    this.logger.debug("Could not find service '{}' for participant '{}'", (Object)serviceID, (Object)participant.getUDN());
                }
            } else {
                this.logger.debug("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
        return resultMap;
    }

    @Override
    public boolean isRegistered(UpnpIOParticipant participant) {
        return this.upnpService.getRegistry().getDevice(new UDN(participant.getUDN()), true) != null;
    }

    @Override
    public void registerParticipant(UpnpIOParticipant participant) {
        Device device;
        if (participant != null && (device = this.participants.get(participant)) == null && (device = this.upnpService.getRegistry().getDevice(new UDN(participant.getUDN()), true)) != null) {
            this.logger.debug("Registering device '{}' for participant '{}'", (Object)device.getIdentity(), (Object)participant.getUDN());
            this.participants.put(participant, device);
        }
    }

    @Override
    public void unregisterParticipant(UpnpIOParticipant participant) {
        if (participant != null) {
            this.stopPollingForParticipant(participant);
            this.pollingJobs.remove(participant);
            this.currentStates.remove(participant);
            this.participants.remove(participant);
        }
    }

    @Override
    public URL getDescriptorURL(UpnpIOParticipant participant) {
        RemoteDevice device = this.upnpService.getRegistry().getRemoteDevice(new UDN(participant.getUDN()), true);
        if (device != null) {
            return ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL();
        }
        return null;
    }

    private Service findService(Device device, String serviceID) {
        Service service = null;
        String namespace = device.getType().getNamespace();
        service = namespace.equals("upnp-org") || namespace.equals("schemas-upnp-org") ? device.findService((ServiceId)new UDAServiceId(serviceID)) : device.findService(new ServiceId(namespace, serviceID));
        return service;
    }

    @Override
    public void addStatusListener(UpnpIOParticipant participant, String serviceID, String actionID, int interval) {
        if (participant != null) {
            this.registerParticipant(participant);
            int pollingInterval = interval == 0 ? 60 : interval;
            this.stopPollingForParticipant(participant);
            this.currentStates.put(participant, true);
            UPNPPollingRunnable pollingRunnable = new UPNPPollingRunnable(participant, serviceID, actionID);
            this.pollingJobs.put(participant, this.scheduler.scheduleAtFixedRate(pollingRunnable, 0L, pollingInterval, TimeUnit.SECONDS));
        }
    }

    private void stopPollingForParticipant(UpnpIOParticipant participant) {
        ScheduledFuture pollingJob;
        if (this.pollingJobs.containsKey(participant) && (pollingJob = this.pollingJobs.get(participant)) != null) {
            pollingJob.cancel(true);
        }
    }

    @Override
    public void removeStatusListener(UpnpIOParticipant participant) {
        if (participant != null) {
            this.unregisterParticipant(participant);
        }
    }

    private class UPNPPollingRunnable
    implements Runnable {
        private UpnpIOParticipant participant;
        private String serviceID;
        private String actionID;

        public UPNPPollingRunnable(UpnpIOParticipant participant, String serviceID, String actionID) {
            this.participant = participant;
            this.serviceID = serviceID;
            this.actionID = actionID;
        }

        @Override
        public void run() {
            try {
                Device device = (Device)UpnpIOServiceImpl.this.participants.get(this.participant);
                if (device != null) {
                    Service service = UpnpIOServiceImpl.this.findService(device, this.serviceID);
                    if (service != null) {
                        Action action = service.getAction(this.actionID);
                        if (action != null) {
                            ActionInvocation invocation = new ActionInvocation(action);
                            if (invocation != null) {
                                UpnpIOServiceImpl.this.logger.debug("Polling participant '{}' through Action '{}' of Service '{}' ", new Object[]{this.participant.getUDN(), this.actionID, this.serviceID});
                                new ActionCallback.Default(invocation, UpnpIOServiceImpl.this.upnpService.getControlPoint()).run();
                                ActionException anException = invocation.getFailure();
                                if (anException != null && anException.getMessage().contains("Connection error or no response received")) {
                                    if (((Boolean)UpnpIOServiceImpl.this.currentStates.get(this.participant)).booleanValue()) {
                                        UpnpIOServiceImpl.this.currentStates.put(this.participant, false);
                                        UpnpIOServiceImpl.this.logger.debug("Signalling that '{}' is not responding", (Object)this.participant.getUDN());
                                        this.participant.onStatusChanged(false);
                                    }
                                } else if (!((Boolean)UpnpIOServiceImpl.this.currentStates.get(this.participant)).booleanValue()) {
                                    UpnpIOServiceImpl.this.currentStates.put(this.participant, true);
                                    UpnpIOServiceImpl.this.logger.debug("Signalling that '{}' is again responding", (Object)this.participant.getUDN());
                                    this.participant.onStatusChanged(true);
                                }
                            }
                        } else {
                            UpnpIOServiceImpl.this.logger.debug("Could not find action '{}' for participant '{}'", (Object)this.actionID, (Object)this.participant.getUDN());
                        }
                    } else {
                        UpnpIOServiceImpl.this.logger.debug("Could not find service '{}' for participant '{}'", (Object)this.serviceID, (Object)this.participant.getUDN());
                    }
                }
            }
            catch (Exception e) {
                UpnpIOServiceImpl.this.logger.error("An exception occurred while polling an UPNP device: '{}'", (Object)e.getStackTrace().toString());
            }
        }
    }

    public class UpnpSubscriptionCallback
    extends SubscriptionCallback {
        public UpnpSubscriptionCallback(Service service) {
            super(service);
        }

        public UpnpSubscriptionCallback(Service service, int requestedDurationSeconds) {
            super(service, requestedDurationSeconds);
        }

        protected void ended(GENASubscription subscription, CancelReason reason, UpnpResponse response) {
            Service service = subscription.getService();
            if (service != null) {
                ControlPoint cp;
                DeviceIdentity deviceRootIdentity;
                Device deviceRoot;
                ServiceId serviceId = service.getServiceId();
                Device device = service.getDevice();
                if (device != null && (deviceRoot = device.getRoot()) != null && (deviceRootIdentity = deviceRoot.getIdentity()) != null) {
                    UDN deviceRootUdn = deviceRootIdentity.getUdn();
                    UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' was ended", (Object)serviceId, (Object)deviceRootUdn);
                }
                if ((CancelReason.EXPIRED.equals((Object)reason) || CancelReason.RENEWAL_FAILED.equals((Object)reason)) && UpnpIOServiceImpl.this.upnpService != null && (cp = UpnpIOServiceImpl.this.upnpService.getControlPoint()) != null) {
                    UpnpSubscriptionCallback callback = new UpnpSubscriptionCallback(service, subscription.getActualDurationSeconds());
                    cp.execute((SubscriptionCallback)callback);
                }
            }
        }

        protected void established(GENASubscription subscription) {
            UpnpIOServiceImpl.this.logger.trace("A GENA subscription '{}' for device '{}' is established", (Object)subscription.getService().getServiceId().getId(), (Object)subscription.getService().getDevice().getRoot().getIdentity().getUdn());
        }

        protected void eventReceived(GENASubscription sub) {
            Map values = sub.getCurrentValues();
            Device device = sub.getService().getDevice();
            UpnpIOServiceImpl.this.logger.trace("Receiving a GENA subscription '{}' response for device '{}'", (Object)sub.getService().getServiceId().getId(), (Object)device.getRoot().getIdentity().getUdn());
            for (UpnpIOParticipant participant : UpnpIOServiceImpl.this.participants.keySet()) {
                if (!((Device)UpnpIOServiceImpl.this.participants.get(participant)).equals((Object)device.getRoot())) continue;
                for (String stateVariable : values.keySet()) {
                    StateVariableValue value = (StateVariableValue)values.get(stateVariable);
                    if (value.getValue() == null) continue;
                    try {
                        participant.onValueReceived(stateVariable, value.getValue().toString(), sub.getService().getServiceId().getId());
                    }
                    catch (Exception e) {
                        UpnpIOServiceImpl.this.logger.error("Participant threw an exception onValueReceived", (Throwable)e);
                    }
                }
            }
        }

        protected void eventsMissed(GENASubscription subscription, int numberOfMissedEvents) {
            UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' missed events", (Object)subscription.getService().getServiceId(), (Object)subscription.getService().getDevice().getRoot().getIdentity().getUdn());
        }

        protected void failed(GENASubscription subscription, UpnpResponse response, Exception e, String defaultMsg) {
            UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' failed", (Object)subscription.getService().getServiceId(), (Object)subscription.getService().getDevice().getRoot().getIdentity().getUdn());
        }
    }
}

