/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.mapdb;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;

public class PropertiesTypeAdapter
extends TypeAdapter<Map<String, Object>> {
    public static final TypeToken<Map<String, Object>> TOKEN = new TypeToken<Map<String, Object>>(){};
    private final TypeAdapter<Map<String, Object>> delegate;
    private final ConstructorConstructor constructor;
    private final TypeAdapter<String> keyAdapter;
    private final TypeAdapter<Object> valueAdapter;

    public PropertiesTypeAdapter(Gson gson) {
        this.keyAdapter = gson.getAdapter(String.class);
        this.valueAdapter = gson.getAdapter(Object.class);
        this.constructor = new ConstructorConstructor(Collections.emptyMap());
        this.delegate = new MapTypeAdapterFactory(this.constructor, false).create(new Gson(), TOKEN);
    }

    public void write(JsonWriter out, Map<String, Object> value) throws IOException {
        this.delegate.write(out, value);
    }

    public Map<String, Object> read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Map map = (Map)this.constructor.get(TOKEN).construct();
        if (peek == JsonToken.BEGIN_ARRAY) {
            in.beginArray();
            while (in.hasNext()) {
                in.beginArray();
                String key = (String)this.keyAdapter.read(in);
                Object value = this.getValue(in);
                Object replaced = map.put(key, value);
                if (replaced != null) {
                    throw new JsonSyntaxException("duplicate key: " + key);
                }
                in.endArray();
            }
            in.endArray();
        } else {
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                String key = (String)this.keyAdapter.read(in);
                Object value = this.getValue(in);
                Object replaced = map.put(key, value);
                if (replaced == null) continue;
                throw new JsonSyntaxException("duplicate key: " + key);
            }
            in.endObject();
        }
        return map;
    }

    private Object getValue(JsonReader in) throws IOException {
        Object value = null;
        value = JsonToken.NUMBER.equals((Object)in.peek()) ? new BigDecimal(in.nextString()) : this.valueAdapter.read(in);
        return value;
    }
}

