/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.config.xml.osgi.AbstractAsyncBundleProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class SyntheticBundleInstaller {
    private static String bundlePoolPath = "/test-bundle-pool";

    public static Bundle install(BundleContext bundleContext, String testBundleName) throws Exception {
        String bundlePath = String.valueOf(bundlePoolPath) + "/" + testBundleName + "/";
        byte[] syntheticBundleBytes = SyntheticBundleInstaller.createSyntheticBundle(bundleContext.getBundle(), bundlePath, testBundleName);
        Bundle syntheticBundle = bundleContext.installBundle(testBundleName, (InputStream)new ByteArrayInputStream(syntheticBundleBytes));
        syntheticBundle.start(32);
        SyntheticBundleInstaller.waitUntilLoadingFinished(syntheticBundle);
        return syntheticBundle;
    }

    public static Bundle installFragment(BundleContext bundleContext, String testBundleName) throws Exception {
        String bundlePath = String.valueOf(bundlePoolPath) + "/" + testBundleName + "/";
        byte[] syntheticBundleBytes = SyntheticBundleInstaller.createSyntheticBundle(bundleContext.getBundle(), bundlePath, testBundleName);
        Bundle syntheticBundle = bundleContext.installBundle(testBundleName, (InputStream)new ByteArrayInputStream(syntheticBundleBytes));
        SyntheticBundleInstaller.waitUntilLoadingFinished(syntheticBundle);
        return syntheticBundle;
    }

    public static void waitUntilLoadingFinished(Bundle bundle) {
        while (!AbstractAsyncBundleProcessor.isBundleFinishedLoading((Bundle)bundle)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void uninstall(BundleContext bundleContext, String testBundleName) throws BundleException {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (testBundleName.equals(bundle.getSymbolicName())) {
                bundle.uninstall();
            }
            ++n2;
        }
    }

    private static byte[] createSyntheticBundle(Bundle bundle, String bundlePath, String bundleName) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Manifest manifest = SyntheticBundleInstaller.getManifest(bundle, bundlePath);
        JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)outputStream, manifest) : new JarOutputStream(outputStream);
        List<String> files = SyntheticBundleInstaller.collectFilesFrom(bundle, bundlePath, bundleName);
        for (String file : files) {
            SyntheticBundleInstaller.addFileToArchive(bundle, bundlePath, file, jarOutputStream);
        }
        jarOutputStream.close();
        return outputStream.toByteArray();
    }

    private static void addFileToArchive(Bundle bundle, String bundlePath, String fileInBundle, JarOutputStream jarOutputStream) throws IOException {
        String filePath = String.valueOf(bundlePath) + "/" + fileInBundle;
        URL resource = bundle.getResource(filePath);
        if (resource == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(fileInBundle);
        jarOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)resource.openStream(), (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private static List<String> collectFilesFrom(Bundle bundle, String bundlePath, String bundleName) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        URL url = SyntheticBundleInstaller.getBaseURL(bundle, bundleName);
        if (url != null) {
            String path = url.getPath();
            URI baseURI = url.toURI();
            List<URL> list = SyntheticBundleInstaller.collectEntries(bundle, path, "*.xml", "*.properties", "*.json");
            for (URL entryURL : list) {
                String fileEntry = SyntheticBundleInstaller.convertToFileEntry(baseURI, entryURL);
                result.add(fileEntry);
            }
        }
        return result;
    }

    private static URL getBaseURL(Bundle bundle, String bundleName) {
        Enumeration entries = bundle.findEntries("/", bundleName, true);
        return entries != null ? (URL)entries.nextElement() : null;
    }

    private static List<URL> collectEntries(Bundle bundle, String path, String ... filePatterns) {
        ArrayList<URL> result = new ArrayList<URL>();
        String[] stringArray = filePatterns;
        int n = filePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String filePattern = stringArray[n2];
            Enumeration entries = bundle.findEntries(path, filePattern, true);
            if (entries != null) {
                result.addAll(Collections.list(entries));
            }
            ++n2;
        }
        return result;
    }

    private static String convertToFileEntry(URI baseURI, URL entryURL) throws URISyntaxException {
        URI entryURI = entryURL.toURI();
        URI relativeURI = baseURI.relativize(entryURI);
        String fileEntry = relativeURI.toString();
        return fileEntry;
    }

    private static Manifest getManifest(Bundle bundle, String bundlePath) throws IOException {
        String filePath = String.valueOf(bundlePath) + "/" + "META-INF/MANIFEST.MF";
        URL resource = bundle.getResource(filePath);
        if (resource == null) {
            return null;
        }
        return new Manifest(resource.openStream());
    }
}

