/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.map.internal;

import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.smarthome.core.transform.AbstractFileTransformationService;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTransformationService
extends AbstractFileTransformationService<Properties> {
    private final Logger logger = LoggerFactory.getLogger(MapTransformationService.class);

    protected String internalTransform(Properties properties, String source) throws TransformationException {
        String target = properties.getProperty(source);
        if (target == null) {
            throw new TransformationException("Target value not found in map for '" + source + "'");
        }
        this.logger.debug("Transformation resulted in '{}'", (Object)target);
        return target;
    }

    protected Properties internalLoadTransform(String filename) throws TransformationException {
        try {
            Properties result = new Properties();
            result.load(new FileReader(filename));
            return result;
        }
        catch (IOException e) {
            throw new TransformationException("An error occured while opening file.", (Throwable)e);
        }
    }
}

