/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.model.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(ChartRenderer.class);

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Chart;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Chart chart = (Chart)w;
        try {
            String itemParam = null;
            Item item = this.itemUIRegistry.getItem(chart.getItem());
            itemParam = item instanceof GroupItem ? "groups=" + chart.getItem() : "items=" + chart.getItem();
            String url = "/chart?" + itemParam + "&period=" + chart.getPeriod() + "&t=" + new Date().getTime();
            if (chart.getService() != null) {
                url = String.valueOf(url) + "&service=" + chart.getService();
            }
            String snippet = this.getSnippet("image");
            snippet = chart.getRefresh() > 0 ? StringUtils.replace((String)snippet, (String)"%refresh%", (String)("id=\"%id%\" data-timeout=\"" + chart.getRefresh() + "\" onload=\"startReloadImage('%url%', '%id%')\"")) : StringUtils.replace((String)snippet, (String)"%refresh%", (String)"");
            snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId(w));
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
            sb.append(snippet);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            this.logger.warn("Chart cannot be rendered as item '{}' does not exist.", (Object)chart.getItem());
        }
        return null;
    }
}

