/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.paper.internal;

import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaperUIApp {
    public static final String WEBAPP_ALIAS = "/ui";
    private final Logger logger = LoggerFactory.getLogger(PaperUIApp.class);
    protected HttpService httpService;

    protected void activate(ComponentContext componentContext) {
        try {
            this.httpService.registerResources(WEBAPP_ALIAS, "web", null);
            this.logger.info("Started Paper UI at /ui");
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.httpService.unregister(WEBAPP_ALIAS);
        this.logger.info("Stopped Paper UI");
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

