angular.module('PaperUI.services.rest', [ 'PaperUI.constants' ]).config(function($httpProvider) {
    var accessToken = function getAccessToken() {
        return $('#authentication').data('access-token')
    }();
    if (accessToken != '{{ACCESS_TOKEN}}') {
        var authorizationHeader = function getAuthorizationHeader() {
            return 'Bearer ' + accessToken
        }();
        $httpProvider.defaults.headers.common['Authorization'] = authorizationHeader;
    }
}).factory('itemService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/items', {}, {
        getAll : {
            method : 'GET',
            isArray : true,
            url : restConfig.restPath + '/items?recursive=true'
        },
        getByName : {
            method : 'GET',
            params : {
                bindingId : '@itemName'
            },
            url : restConfig.restPath + '/items/:itemName'
        },
        remove : {
            method : 'DELETE',
            params : {
                itemName : '@itemName'
            },
            url : restConfig.restPath + '/items/:itemName'
        },
        create : {
            method : 'PUT',
            params : {
                itemName : '@itemName'
            },
            url : restConfig.restPath + '/items/:itemName'
        },
        updateState : {
            method : 'PUT',
            params : {
                itemName : '@itemName'
            },
            url : restConfig.restPath + '/items/:itemName/state',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        sendCommand : {
            method : 'POST',
            params : {
                itemName : '@itemName'
            },
            url : restConfig.restPath + '/items/:itemName',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        addMember : {
            method : 'PUT',
            params : {
                itemName : '@itemName',
                memberItemName : '@memberItemName'
            },
            url : restConfig.restPath + '/items/:itemName/members/:memberItemName'
        },
        removeMember : {
            method : 'DELETE',
            params : {
                itemName : '@itemName',
                memberItemName : '@memberItemName'
            },
            url : restConfig.restPath + '/items/:itemName/members/:memberItemName'
        },
        addTag : {
            method : 'PUT',
            params : {
                itemName : '@itemName',
                tag : '@tag'
            },
            url : restConfig.restPath + '/items/:itemName/tags/:tag'
        },
        removeTag : {
            method : 'DELETE',
            params : {
                itemName : '@itemName',
                tag : '@tag'
            },
            url : restConfig.restPath + '/items/:itemName/tags/:tag'
        },
        getNonRecursiveAll : {
            method : 'GET',
            isArray : true,
            url : restConfig.restPath + '/items?recursive=false'
        },
    });
}).factory('bindingService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/bindings', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getConfigById : {
            method : 'GET',
            params : {
                id : '@id'
            },
            interceptor : {
                response : function(response) {
                    return response.data;
                }
            },
            url : restConfig.restPath + '/bindings/:id/config'
        },
        updateConfig : {
            method : 'PUT',
            headers : {
                'Content-Type' : 'application/json'
            },
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/bindings/:id/config'
        },
    });
}).factory('inboxService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/inbox', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        approve : {
            method : 'POST',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/inbox/:thingUID/approve',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        ignore : {
            method : 'POST',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/inbox/:thingUID/ignore'
        },
        unignore : {
            method : 'POST',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/inbox/:thingUID/unignore'
        },
        remove : {
            method : 'DELETE',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/inbox/:thingUID'
        }
    })
}).factory('discoveryService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/discovery', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        scan : {
            method : 'POST',
            params : {
                bindingId : '@bindingId'
            },
            url : restConfig.restPath + '/discovery/bindings/:bindingId/scan'
        }
    });
}).factory('thingTypeService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/thing-types', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUid : {
            method : 'GET',
            params : {
                bindingId : '@thingTypeUID'
            },
            url : restConfig.restPath + '/thing-types/:thingTypeUID'
        }
    });
}).factory('linkService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/links', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        link : {
            method : 'PUT',
            params : {
                itemName : '@itemName',
                channelUID : '@channelUID'
            },
            url : restConfig.restPath + '/links/:itemName/:channelUID'
        },
        unlink : {
            method : 'DELETE',
            params : {
                itemName : '@itemName',
                channelUID : '@channelUID'
            },
            url : restConfig.restPath + '/links/:itemName/:channelUID'
        }
    });
}).factory('thingService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/things', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUid : {
            method : 'GET',
            params : {
                bindingId : '@thingUID'
            },
            url : restConfig.restPath + '/things/:thingUID'
        },
        remove : {
            method : 'DELETE',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/things/:thingUID'
        },
        add : {
            method : 'POST',
            url : restConfig.restPath + '/things',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        update : {
            method : 'PUT',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/things/:thingUID',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        updateConfig : {
            method : 'PUT',
            params : {
                thingUID : '@thingUID'
            },
            url : restConfig.restPath + '/things/:thingUID/config',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        link : {
            method : 'POST',
            params : {
                thingUID : '@thingUID',
                channelId : '@channelId'
            },
            url : restConfig.restPath + '/things/:thingUID/channels/:channelId/link',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        unlink : {
            method : 'DELETE',
            params : {
                thingUID : '@thingUID',
                channelId : '@channelId'
            },
            url : restConfig.restPath + '/things/:thingUID/channels/:channelId/link',
        }
    });
}).factory('serviceConfigService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/services', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getById : {
            method : 'GET',
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/services/:id'
        },
        getConfigById : {
            method : 'GET',
            params : {
                id : '@id'
            },
            interceptor : {
                response : function(response) {
                    return response.data;
                }
            },
            url : restConfig.restPath + '/services/:id/config'
        },
        updateConfig : {
            method : 'PUT',
            headers : {
                'Content-Type' : 'application/json'
            },
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/services/:id/config'
        },
        deleteConfig : {
            method : 'DELETE',
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/services/:id/config'
        },
    });
}).factory('configDescriptionService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/config-descriptions', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUri : {
            method : 'GET',
            params : {
                uri : '@uri'
            },
            url : restConfig.restPath + '/config-descriptions/:uri'
        },
    });
}).factory('extensionService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/extensions', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUri : {
            method : 'GET',
            params : {
                uri : '@id'
            },
            url : restConfig.restPath + '/extensions/:id'
        },
        getAllTypes : {
            method : 'GET',
            isArray : true,
            url : restConfig.restPath + '/extensions/types'
        },
        install : {
            method : 'POST',
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/extensions/:id/install'
        },
        uninstall : {
            method : 'POST',
            params : {
                id : '@id'
            },
            url : restConfig.restPath + '/extensions/:id/uninstall'
        }
    });
}).factory('ruleService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/rules', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUid : {
            method : 'GET',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID'
        },
        add : {
            method : 'POST',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        remove : {
            method : 'DELETE',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID'
        },
        getModuleConfigParameter : {
            method : 'GET',
            params : {
                ruleUID : '@ruleUID'
            },
            transformResponse : function(data, headersGetter, status) {
                return {
                    content : data
                };
            },
            url : restConfig.restPath + '/rules/:ruleUID/actions/action/config/script'
        },
        setModuleConfigParameter : {
            method : 'PUT',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID/actions/action/config/script',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        update : {
            method : 'PUT',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        setEnabled : {
            method : 'POST',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID/enable',
            headers : {
                'Content-Type' : 'text/plain'
            }
        },
        getRuleTemplates : {
            method : 'GET',
            url : restConfig.restPath + '/templates',
            isArray : true
        }
    });
}).factory('moduleTypeService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/module-types', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByType : {
            method : 'GET',
            params : {
                mtype : '@mtype'
            },
            url : restConfig.restPath + '/module-types?type=:mtype',
            isArray : true
        },
        getByUid : {
            method : 'GET',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID'
        },
        getModuleConfigByUid : {
            method : 'GET',
            params : {
                ruleUID : '@ruleUID',
                moduleCategory : '@moduleCategory',
                id : '@id'

            },
            url : restConfig.restPath + '/rules/:ruleUID/:moduleCategory/:id/config'
        },
        add : {
            method : 'POST',
            headers : {
                'Content-Type' : 'application/json'
            }
        },
        remove : {
            method : 'DELETE',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID'
        },
        getModuleConfigParameter : {
            method : 'GET',
            params : {
                ruleUID : '@ruleUID'
            },
            transformResponse : function(data, headersGetter, status) {
                return {
                    content : data
                };
            },
            url : restConfig.restPath + '/rules/:ruleUID/actions/action/config/script'
        },
        setModuleConfigParameter : {
            method : 'PUT',
            params : {
                ruleUID : '@ruleUID'
            },
            url : restConfig.restPath + '/rules/:ruleUID/actions/action/config/script',
            headers : {
                'Content-Type' : 'text/plain'
            }
        }
    });
}).factory('channelTypeService', function($resource, restConfig) {
    return $resource(restConfig.restPath + '/channel-types', {}, {
        getAll : {
            method : 'GET',
            isArray : true
        },
        getByUri : {
            method : 'GET',
            params : {
                channelTypeUID : '@channelTypeUID'
            },
            url : restConfig.restPath + '/channel-types/:channelTypeUID'
        },
    });
});
var Repository = function($q, $rootScope, remoteService, dataType, staticData) {
    var self = this;
    var cacheEnabled = true;
    var dirty = false;
    var initialFetch = false;

    this.setDirty = function() {
        this.dirty = true;
    }
    this.getAll = function(callback, refresh) {
        if (typeof callback === 'boolean') {
            refresh = true;
            callback = null;
        }
        var deferred = $q.defer();
        deferred.promise.then(function(res) {
            if (callback && res !== 'No update') {
                return callback(res);
            } else {
                return;
            }
        }, function(res) {
            return;
        }, function(res) {
            if (callback) {
                return callback(res);
            } else {
                return;
            }
        });
        if (cacheEnabled && staticData && self.initialFetch && !refresh && !self.dirty) {
            deferred.resolve($rootScope.data[dataType]);
        } else {
            remoteService.getAll(function(data) {
                if ((!cacheEnabled || (data.length != $rootScope.data[dataType].length) || self.dirty || refresh)) {
                    self.initialFetch = true;
                    $rootScope.data[dataType] = data;
                    self.dirty = false;
                    deferred.resolve(data);
                } else {
                    // set initial data
                    if (!self.initialFetch) {
                        self.initialFetch = true;
                        $rootScope.data[dataType] = data;
                        self.dirty = false;
                    }
                    deferred.resolve('No update');
                }
            });
            if (cacheEnabled && self.initialFetch) {
                deferred.notify($rootScope.data[dataType]);
            }
        }
        return deferred.promise;
    };
    this.getOne = function(condition, callback, refresh) {
        var element = self.find(condition);
        if (element != null && !this.dirty && !refresh) {
            callback(element);
        } else {
            self.getAll(null, true).then(function(res) {
                if (callback) {
                    callback(self.find(condition));
                    return;
                } else {
                    return;
                }
            }, function(res) {
                callback(null);
                return;
            }, function(res) {
                return;
            });
        }
    };
    this.find = function(condition) {
        for (var i = 0; i < $rootScope.data[dataType].length; i++) {
            var element = $rootScope.data[dataType][i];
            if (condition(element)) {
                return element;
            }
        }
        return null;
    };
    this.add = function(element) {
        $rootScope.data[dataType].push(element);
    };
    this.remove = function(element) {
        $rootScope.data[dataType].splice($rootScope.data[dataType].indexOf(element), 1);
    };
    this.update = function(element) {
        var index = $rootScope.data[dataType].indexOf(element);
        $rootScope.data[dataType][index] = element;
    };
}

angular.module('PaperUI.services.repositories', []).factory('bindingRepository', function($q, $rootScope, bindingService) {
    $rootScope.data.bindings = [];
    return new Repository($q, $rootScope, bindingService, 'bindings', true);
}).factory('thingTypeRepository', function($q, $rootScope, thingTypeService) {
    $rootScope.data.thingTypes = [];
    return new Repository($q, $rootScope, thingTypeService, 'thingTypes', true);
}).factory('discoveryResultRepository', function($q, $rootScope, inboxService, eventService) {
    var repository = new Repository($q, $rootScope, inboxService, 'discoveryResults')
    $rootScope.data.discoveryResults = [];
    eventService.onEvent('smarthome/inbox/*', function(topic, discoveryResult) {
        if (topic.indexOf("added") > -1) {
            repository.add(discoveryResult);
        }
        if (topic.indexOf("removed") > -1) {
            repository.remove(discoveryResult);
        }
    });
    return repository;
}).factory('thingRepository', function($q, $rootScope, thingService, eventService) {
    var repository = new Repository($q, $rootScope, thingService, 'things')
    $rootScope.data.things = [];

    var itemNameToThingUID = function(itemName) {
        return itemName.replace(/_/g, ':')
    }
    var updateInRepository = function(thingUID, mustExist, action) {
        var existing = repository.find(function(thing) {
            return thing.UID === thingUID;
        });
        if ((existing && mustExist) || (!existing && !mustExist)) {
            $rootScope.$apply(function(scope) {
                action(existing)
            });
        }
    }

    eventService.onEvent('smarthome/things/*/status', function(topic, statusInfo) {
        updateInRepository(topic.split('/')[2], true, function(existingThing) {
            existingThing.statusInfo = statusInfo;
        });
    });
    eventService.onEvent('smarthome/things/*/added', function(topic, thing) {
        updateInRepository(topic.split('/')[2], false, function(existingThing) {
            repository.add(thing);
        });
    });
    eventService.onEvent('smarthome/things/*/removed', function(topic, thing) {
        updateInRepository(topic.split('/')[2], true, function(existingThing) {
            repository.remove(existingThing);
        });
    });
    eventService.onEvent('smarthome/items/*/added', function(topic, item) {
        updateInRepository(itemNameToThingUID(topic.split('/')[2]), true, function(existingThing) {
            existingThing.item = item
        });
    });
    eventService.onEvent('smarthome/items/*/updated', function(topic, itemUpdate) {
        updateInRepository(itemNameToThingUID(topic.split('/')[2]), true, function(existingThing) {
            existingThing.item = itemUpdate[0]
        });
    });

    return repository;
}).factory('itemRepository', function($q, $rootScope, itemService) {
    var repository = new Repository($q, $rootScope, itemService, 'items')
    $rootScope.data.items = [];
    return repository;
}).factory('ruleRepository', function($q, $rootScope, ruleService) {
    var repository = new Repository($q, $rootScope, ruleService, 'rules')
    $rootScope.data.rules = [];
    return repository;
});
angular.module('PaperUI.services', [ 'PaperUI.constants' ]).config(function($httpProvider) {
    var language = localStorage.getItem('language');
    if (language) {
        $httpProvider.defaults.headers.common['Accept-Language'] = language;
    }
    $httpProvider.interceptors.push(function($q, $injector) {
        return {
            'responseError' : function(rejection) {
                $injector.get('toastService').showErrorToast('ERROR: ' + rejection.status + ' - ' + rejection.statusText);
                return $q.reject(rejection);
            }
        };
    });
}).factory('eventService', function($resource, $log, restConfig) {

    var callbacks = [];
    var eventSrc;

    var initializeEventService = function() {

        eventSrc = new EventSource(restConfig.eventPath)
        $log.debug('Initializing event service.')

        eventSrc.addEventListener('error', function(event) {
            if (eventSrc.readyState === 2) { // CLOSED
                $log.debug('Event connection broken. Trying to reconnect in 5 seconds.');
                setTimeout(initializeEventService, 5000);
            }
        });
        eventSrc.addEventListener('message', function(event) {
            var data = JSON.parse(event.data);
            $log.debug('Event received: ' + data.topic + ' - ' + data.payload);
            $.each(callbacks, function(index, element) {
                if (data.topic.match(element.topic)) {
                    element.callback(data.topic, JSON.parse(data.payload));
                }
            });
        });
    }
    initializeEventService();

    return new function() {
        this.onEvent = function(topic, callback) {
            var topicRegex = topic.replace('/', '\/').replace('*', '.*');
            callbacks.push({
                topic : topicRegex,
                callback : callback
            });
        }
    };
}).factory('toastService', function($mdToast, $rootScope) {
    return new function() {
        var self = this;
        this.showToast = function(id, text, actionText, actionUrl) {
            var toast = $mdToast.simple().content(text);
            if (actionText) {
                toast.action(actionText);
                toast.hideDelay(6000);
            } else {
                toast.hideDelay(3000);
            }
            toast.position('bottom right');
            $mdToast.show(toast).then(function(value) {
                if (value == "ok") {
                    $rootScope.$location.path(actionUrl);
                }
            });
        }
        this.showDefaultToast = function(text, actionText, actionUrl) {
            self.showToast('default', text, actionText, actionUrl);
        }
        this.showErrorToast = function(text, actionText, actionUrl) {
            self.showToast('error', text, actionText, actionUrl);
        }
        this.showSuccessToast = function(text, actionText, actionUrl) {
            self.showToast('success', text, actionText, actionUrl);
        }
    };
}).factory('configService', function(itemService, $filter) {
    return {
        getRenderingModel : function(configParameters, configGroups) {
            var parameters = [];
            if (!configGroups) {
                configGroups = [];
            }
            configGroups.push({
                "name" : "_default",
                "label" : "Others"
            });
            var indexArray = [];
            for (var j = 0; j < configGroups.length; j++) {
                indexArray[configGroups[j].name] = j;
            }
            if (!configParameters) {
                return parameters;
            }
            var groupsList = [];
            for (var j = 0; j < configGroups.length; j++) {
                groupsList[j] = {};
                groupsList[j].parameters = [];
            }
            var itemsList;
            for (var i = 0; i < configParameters.length; i++) {
                var parameter = configParameters[i];

                var group = [];
                if (!parameter.groupName) {
                    parameter.groupName = "_default";
                }
                group = $filter('filter')(configGroups, {
                    name : parameter.groupName
                }, true);
                if (parameter.context && parameter.context.toUpperCase() === 'ITEM') {
                    parameter.element = 'select';
                    itemsList = itemsList === undefined ? itemService.getAll() : itemsList;
                    parameter.options = itemsList;
                } else if (parameter.context && parameter.context.toUpperCase() === 'SCRIPT') {
                    parameter.element = 'textarea';
                    parameter.inputType = 'text';
                    parameter.label = parameter.label && parameter.label.length > 0 ? parameter.label : 'Script';
                } else if (parameter.type.toUpperCase() === 'TEXT') {
                    if (parameter.options && parameter.options.length > 0) {
                        parameter.element = 'select';
                        parameter.options = parameter.options;
                    } else {
                        parameter.element = 'input';
                        parameter.inputType = parameter.context === 'password' ? 'password' : 'text';
                    }
                } else if (parameter.type.toUpperCase() === 'BOOLEAN') {
                    parameter.element = 'switch';
                } else if (parameter.type.toUpperCase() === 'INTEGER' || parameter.type.toUpperCase() === 'DECIMAL') {
                    if (parameter.options && parameter.options.length > 0) {
                        parameter.element = 'select';
                        for (var k = 0; k < parameter.options.length; k++) {
                            parameter.options[k].value = parseInt(parameter.options[k].value);
                        }
                        if (parameter.defaultValue) {
                            parameter.defaultValue = parseInt(parameter.defaultValue);
                        }
                    } else {
                        parameter.element = 'input';
                        parameter.inputType = 'number';
                    }
                } else {
                    parameter.element = 'input';
                    parameter.inputType = 'text';
                }
                groupsList[indexArray[group[0].name]].groupName = group[0].name;
                groupsList[indexArray[group[0].name]].groupLabel = group[0].label;
                groupsList[indexArray[group[0].name]].parameters.push(parameter);
            }
            for (var j = 0; j < groupsList.length; j++) {
                if (groupsList[j].groupName) {
                    parameters.push(groupsList[j]);
                }
            }
            return parameters;
        },
        getConfigAsArray : function(config) {
            var configArray = [];
            angular.forEach(config, function(value, name) {
                var value = config[name];
                configArray.push({
                    name : name,
                    value : value
                });
            });
            return configArray;
        },
        getConfigAsObject : function(configArray, paramGroups) {
            var config = {};

            for (var i = 0; configArray && i < configArray.length; i++) {
                var configEntry = configArray[i];
                var param = getParameter(configEntry.name);
                if (param !== null && param.type.toUpperCase() == "BOOLEAN") {
                    configEntry.value = String(configEntry.value).toUpperCase() == "TRUE";
                }
                config[configEntry.name] = configEntry.value;
            }
            function getParameter(itemName) {
                for (var i = 0; i < paramGroups.length; i++) {
                    for (var j = 0; paramGroups[i].parameters && j < paramGroups[i].parameters.length; j++) {
                        if (paramGroups[i].parameters[j].name == itemName) {
                            return paramGroups[i].parameters[j]
                        }
                    }
                }
                return null;
            }
            return config;
        },
        setDefaults : function(thing, thingType) {
            if (thingType && thingType.configParameters) {
                $.each(thingType.configParameters, function(i, parameter) {
                    if (parameter.defaultValue !== 'null') {
                        if (parameter.type === 'TEXT') {
                            thing.configuration[parameter.name] = parameter.defaultValue
                        } else if (parameter.type === 'BOOLEAN') {
                            thing.configuration[parameter.name] = new Boolean(parameter.defaultValue);
                        } else if (parameter.type === 'INTEGER' || parameter.type === 'DECIMAL') {
                            thing.configuration[parameter.name] = parseInt(parameter.defaultValue);
                        } else {
                            thing.configuration[parameter.name] = parameter.defaultValue;
                        }
                    } else {
                        thing.configuration[parameter.name] = null;
                    }
                });
            }
        },
        setConfigDefaults : function(configuration, groups) {
            for (var i = 0; i < groups.length; i++) {
                $.each(groups[i].parameters, function(i, parameter) {
                    var hasValue = configuration[parameter.name] != null && String(configuration[parameter.name]).length > 0;
                    if (!hasValue && parameter.type === 'TEXT') {
                        configuration[parameter.name] = parameter.defaultValue
                    } else if (parameter.type === 'BOOLEAN') {
                        var value = hasValue ? configuration[parameter.name] : parameter.defaultValue;
                        if (String(value).length > 0) {
                            configuration[parameter.name] = String(value).toUpperCase() == "TRUE";
                        }
                    } else if (!hasValue && parameter.type === 'INTEGER' || parameter.type === 'DECIMAL') {
                        configuration[parameter.name] = parseInt(parameter.defaultValue);
                    } else if (!hasValue) {
                        configuration[parameter.name] = parameter.defaultValue;
                    }
                });
            }
            return configuration;
        },
        convertValues : function(configurations) {
            angular.forEach(configurations, function(value, name) {
                if (value && typeof (value) !== "boolean") {
                    var parsedValue = Number(value);
                    if (isNaN(parsedValue)) {
                        if (value.toUpperCase() == 'TRUE') {
                            configurations[name] = true;
                        } else if (value.toUpperCase() == 'FALSE') {
                            configurations[name] = false;
                        } else {
                            configurations[name] = value;
                        }

                    } else {
                        configurations[name] = parsedValue;
                    }
                }
            });
            return configurations;
        },
        replaceEmptyValues : function(configurations) {
            angular.forEach(configurations, function(value, name) {
                if (configurations[name] === undefined || configurations[name] == null || configurations[name] === '') {
                    configurations[name] = null;
                }
            });
            return configurations;
        }
    };
}).factory('thingConfigService', function() {
    return {
        getThingChannels : function(thing, thingType, channelTypes, advanced) {
            var thingChannels = [];
            var includedChannels = [];
            if (thingType.channelGroups && thingType.channelGroups.length > 0) {
                for (var i = 0; i < thingType.channelGroups.length; i++) {
                    var group = {};
                    group.name = thingType.channelGroups[i].label;
                    group.description = thingType.channelGroups[i].description;
                    group.channels = this.matchGroup(thing.channels, thingType.channelGroups[i].id);
                    includedChannels = includedChannels.concat(group.channels);
                    group.channels = advanced ? group.channels : this.filterAdvance(thingType, channelTypes, group.channels, false);
                    thingChannels.push(group);
                }
                var group = {
                    "name" : "Others",
                    "description" : "Other channels",
                    "channels" : []
                };
                for (var i = 0; i < thing.channels.length; i++) {
                    if (includedChannels.indexOf(thing.channels[i]) == -1) {
                        group.channels.push(thing.channels[i]);
                    }
                }
                if (group.channels && group.channels.length > 0) {
                    thingChannels.push(group);
                }
            } else {
                var group = {};
                group.channels = advanced ? thing.channels : this.filterAdvance(thingType, channelTypes, thing.channels, advanced);
                thingChannels.push(group);
            }

            return thingChannels;
        },

        filterAdvance : function(thingType, channelTypes, channels, advanced) {
            var self = this;
            self.thingType = thingType, self.channelTypes = channelTypes, self.channels = channels;
            return $.grep(channels, function(channel, i) {
                var channelType = self.getChannelTypeById(self.thingType, self.channelTypes, channel.id);
                return channelType ? advanced == channelType.advanced : true;
            });
        },
        getChannelTypeById : function(thingType, channelTypes, channelId) {
            if (thingType) {
                var cid_part = channelId.split('#', 2)
                if (cid_part.length == 1) {
                    var c, c_i, c_l;
                    for (c_i = 0, c_l = thingType.channels.length; c_i < c_l; ++c_i) {
                        c = thingType.channels[c_i];
                        if (c.id == channelId) {
                            return c;
                        }
                    }
                } else if (cid_part.length == 2) {
                    var cg, cg_i, cg_l;
                    var c, c_i, c_l;
                    for (cg_i = 0, cg_l = thingType.channelGroups.length; cg_i < cg_l; ++cg_i) {
                        cg = thingType.channelGroups[cg_i];
                        if (cg.id == cid_part[0]) {
                            for (c_i = 0, c_l = cg.channels.length; c_i < c_l; ++c_i) {
                                c = cg.channels[c_i];
                                if (c.id == cid_part[1]) {
                                    return c;
                                }
                            }
                        }
                    }
                } else {
                    return;
                }
            }
            if (channelTypes) {
                var c = {}, c_i, c_l;
                for (c_i = 0, c_l = channelTypes.length; c_i < c_l; ++c_i) {
                    c = channelTypes[c_i];
                    c.advanced = false;
                    var id = c.UID.split(':', 2);
                    if (id[1] == channelId) {
                        return c;
                    }
                }
            }
            return;
        },
        getChannelFromChannelTypes : function(channelTypes, channelUID) {
            if (channelTypes) {
                var c = {}, c_i, c_l;
                for (c_i = 0, c_l = channelTypes.length; c_i < c_l; ++c_i) {
                    c = channelTypes[c_i];
                    if (c.UID == channelUID) {
                        return c;
                    }
                }
            }
            return;
        },
        matchGroup : function(arr, id) {
            var matched = [];
            for (var i = 0; i < arr.length; i++) {
                if (arr[i].id) {
                    var sub = arr[i].id.split("#");
                    if (sub[0] && sub[0] == id) {
                        matched.push(arr[i]);
                    }
                }
            }
            return matched;
        }
    }
}).factory('util', function() {
    return {
        hasProperties : function(object) {
            if (typeof jQuery !== 'undefined') {
                return !jQuery.isEmptyObject(object);
            } else {
                if (object) {
                    return Object.keys(object).length > 0;
                }
                return false;
            }
        }
    }
});