/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommand;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.internal.commands.Printer;

public class AutomationCommandEnableRule
extends AutomationCommand {
    private boolean enable;
    private boolean hasEnable;
    private String uid;

    public AutomationCommandEnableRule(String command, String[] parameterValues, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, parameterValues, providerType, autoCommands);
    }

    @Override
    public String execute() {
        if (this.parsingResult != "SUCCESS") {
            return this.parsingResult;
        }
        if (this.hasEnable) {
            this.autoCommands.setEnabled(this.uid, this.enable);
            return "SUCCESS";
        }
        RuleStatus status = this.autoCommands.getRuleStatus(this.uid);
        if (status != null) {
            return Printer.printRuleStatus(this.uid, status);
        }
        return "FAIL";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if (parameterValues[i].charAt(0) == '-') {
                    if (!parameterValues[i].equals("-st")) return String.format("Unsupported option: %s", parameterValues[i]);
                    this.st = true;
                } else if (this.uid == null) {
                    this.uid = parameterValues[i];
                } else {
                    this.getEnable(parameterValues[i]);
                    if (!this.hasEnable) {
                        if (this.uid != null) return String.format("Unsupported parameter: %s", parameterValues[i]);
                        return "Missing required parameter: Rule UID";
                    }
                }
            }
            ++i;
        }
        return "SUCCESS";
    }

    private void getEnable(String parameterValue) {
        if (parameterValue.equals("true")) {
            this.enable = true;
            this.hasEnable = true;
        } else if (parameterValue.equals("false")) {
            this.enable = false;
            this.hasEnable = true;
        } else {
            this.hasEnable = false;
        }
    }
}

