/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommand;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.type.TriggerType;

public class AutomationCommandExport
extends AutomationCommand {
    private static final String OPTION_P = "-p";
    private String parserType = "json";
    private File file;
    private Locale locale = Locale.getDefault();

    public AutomationCommandExport(String command, String[] params, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, params, providerType, autoCommands);
    }

    @Override
    public String execute() {
        if (this.parsingResult != "SUCCESS") {
            return this.parsingResult;
        }
        HashSet<Rule> set = new HashSet<Rule>();
        switch (this.providerType) {
            case 3: {
                Collection<TriggerType> collection = this.autoCommands.getTriggers(this.locale);
                if (collection != null) {
                    set.addAll(collection);
                }
                if ((collection = this.autoCommands.getConditions(this.locale)) != null) {
                    set.addAll(collection);
                }
                if ((collection = this.autoCommands.getActions(this.locale)) != null) {
                    set.addAll(collection);
                }
                try {
                    return this.autoCommands.exportModuleTypes(this.parserType, set, this.file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
            case 2: {
                Collection<RuleTemplate> collection = this.autoCommands.getTemplates(this.locale);
                if (collection != null) {
                    set.addAll(collection);
                }
                try {
                    return this.autoCommands.exportTemplates(this.parserType, set, this.file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
            case 1: {
                Collection<Rule> collection = this.autoCommands.getRules();
                if (collection != null) {
                    set.addAll(collection);
                }
                try {
                    return this.autoCommands.exportRules(this.parserType, set, this.file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
        }
        return String.format("%s : Unsupported provider type!", "FAIL");
    }

    private File initFile(String parameterValue) {
        File f = new File(parameterValue);
        File parent = f.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            return null;
        }
        return f;
    }

    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getFile = true;
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if (parameterValues[i].equals("-st")) {
                    this.st = true;
                } else if (parameterValues[i].equalsIgnoreCase(OPTION_P)) {
                    if (++i >= parameterValues.length) {
                        return String.format("The option [%s] should be followed by value for the parser type.", OPTION_P);
                    }
                    this.parserType = parameterValues[i];
                } else {
                    if (parameterValues[i].charAt(0) == '-') {
                        return String.format("Unsupported option: %s", parameterValues[i]);
                    }
                    if (getFile) {
                        this.file = this.initFile(parameterValues[i]);
                        if (this.file != null) {
                            getFile = false;
                        }
                    } else {
                        return String.format("Unsupported parameter: %s", parameterValues[i]);
                    }
                }
            }
            ++i;
        }
        if (getFile) {
            return "Missing destination file parameter!";
        }
        return "SUCCESS";
    }
}

