/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolverUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceResolverUtil.class);

    private ReferenceResolverUtil() {
    }

    public static void updateModuleConfiguration(Module module, Map<String, ?> context) {
        Configuration config = module.getConfiguration();
        for (String configKey : config.keySet()) {
            Object result;
            Object o = config.get(configKey);
            if (!(o instanceof String)) continue;
            String childConfigPropertyValue = (String)o;
            if (ReferenceResolverUtil.isReference(childConfigPropertyValue)) {
                result = ReferenceResolverUtil.resolveReference(childConfigPropertyValue, context);
                if (result == null) continue;
                config.put(configKey, result);
                continue;
            }
            if (!ReferenceResolverUtil.containsPattern(childConfigPropertyValue)) continue;
            result = ReferenceResolverUtil.resolvePattern(childConfigPropertyValue, context);
            config.put(configKey, result);
        }
    }

    public static Map<String, Object> getCompositeChildContext(Module module, Map<String, ?> compositeContext) {
        HashMap<String, Object> resultContext = new HashMap<String, Object>();
        Map inputs = null;
        if (module instanceof Condition) {
            inputs = ((Condition)module).getInputs();
        } else if (module instanceof Action) {
            inputs = ((Action)module).getInputs();
        }
        if (inputs != null) {
            for (Map.Entry input : inputs.entrySet()) {
                String inputName = (String)input.getKey();
                String inputValue = (String)input.getValue();
                if (!ReferenceResolverUtil.isReference(inputValue)) continue;
                Object result = ReferenceResolverUtil.resolveReference(inputValue, compositeContext);
                resultContext.put(inputName, result);
            }
        }
        return resultContext;
    }

    public static Object resolveReference(String reference, Map<String, ?> context) {
        String result = reference;
        if (ReferenceResolverUtil.isReference(reference)) {
            String trimmedVal = reference.trim();
            result = context.get(trimmedVal.substring(2, trimmedVal.length() - 1));
        }
        return result;
    }

    private static String resolvePattern(String reference, Map<String, ?> context) {
        int start;
        StringBuilder sb = new StringBuilder();
        int previous = 0;
        while ((start = reference.indexOf("${", previous)) != -1) {
            sb.append(reference.substring(previous, start));
            int end = reference.indexOf(125, start + 2);
            if (end == -1) {
                previous = start;
                logger.warn("Couldn't parse referenced key: {}: expected reference syntax-> ${referencedKey}", (Object)reference.substring(start));
                break;
            }
            String referencedKey = reference.substring(start + 2, end);
            Object referencedValue = context.get(referencedKey);
            if (referencedValue != null) {
                sb.append(referencedValue);
            } else {
                sb.append(reference.substring(start, end + 1));
                logger.warn("Cannot find reference for ${ {} } , it will remain the same.", (Object)referencedKey);
            }
            previous = end + 1;
        }
        sb.append(reference.substring(previous));
        return sb.toString();
    }

    private static boolean isReference(String value) {
        String trimmedVal;
        String string = trimmedVal = value == null ? null : value.trim();
        return trimmedVal != null && trimmedVal.lastIndexOf("${") == 0 && trimmedVal.indexOf(125) == trimmedVal.length() - 1 && trimmedVal.length() > 3;
    }

    private static boolean containsPattern(String value) {
        return value != null && value.trim().contains("${") && value.trim().indexOf("${") < value.trim().indexOf("}");
    }

    public static Object getValue(Object object, String ref) {
        int idx;
        Object result;
        block11: {
            result = null;
            idx = -1;
            if (object == null) {
                return null;
            }
            if (ref == null || ref.length() == 0) {
                return object;
            }
            char ch = ref.charAt(0);
            if ('.' == ch) {
                ref = ref.substring(1, ref.length());
            }
            if ('[' == ch) {
                if (!(object instanceof Map)) {
                    return null;
                }
                idx = ref.indexOf(93);
                if (idx == -1) {
                    return null;
                }
                String key = ref.substring(1, idx++);
                Map map = (Map)object;
                result = map.get(key);
            } else {
                String key = null;
                idx = ReferenceResolverUtil.getNextRefToken(ref, 1);
                key = idx != ref.length() ? ref.substring(0, idx) : ref;
                String getter = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
                try {
                    Method m = object.getClass().getMethod(getter, new Class[0]);
                    if (m != null) {
                        result = m.invoke(object, null);
                        break block11;
                    }
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        if (result != null && idx < ref.length()) {
            return ReferenceResolverUtil.getValue(result, ref.substring(idx));
        }
        return result;
    }

    public static int getNextRefToken(String ref, int startIndex) {
        int idx1 = ref.indexOf(91, startIndex);
        int idx2 = ref.indexOf(46, startIndex);
        int idx = idx1 != -1 && (idx2 == -1 || idx1 < idx2) ? idx1 : (idx2 != -1 && (idx1 == -1 || idx2 < idx1) ? idx2 : ref.length());
        return idx;
    }
}

