/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.slf4j.LoggerFactory;

public class RuntimeCondition
extends Condition {
    private ConditionHandler conditionHandler;
    private Set<Connection> connections;

    public RuntimeCondition(Condition condition) {
        super(condition.getId(), condition.getTypeUID(), condition.getConfiguration(), condition.getInputs());
        this.setConnections(Connection.getConnections(condition.getInputs(), LoggerFactory.getLogger(((Object)((Object)this)).getClass())));
        this.setLabel(condition.getLabel());
        this.setDescription(condition.getDescription());
    }

    void setConnections(Set<Connection> connections) {
        this.connections = connections;
    }

    public Set<Connection> getConnections() {
        return this.connections;
    }

    Set<Connection> copyConnections(Set<Connection> connections) {
        if (connections == null) {
            return null;
        }
        HashSet<Connection> result = new HashSet<Connection>(connections.size());
        for (Connection c : connections) {
            result.add(new Connection(c.getInputName(), c.getOuputModuleId(), c.getOutputName()));
        }
        return result;
    }

    ConditionHandler getModuleHandler() {
        return this.conditionHandler;
    }

    public void setModuleHandler(ConditionHandler conditionHandler) {
        this.conditionHandler = conditionHandler;
    }
}

