/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.RuntimeAction;
import org.eclipse.smarthome.automation.core.internal.RuntimeCondition;
import org.eclipse.smarthome.automation.core.internal.RuntimeTrigger;

public class RuntimeRule
extends Rule {
    private Map<String, Module> moduleMap;

    protected RuntimeRule(Rule rule) {
        super(rule.getUID(), RuntimeRule.getRuntimeTriggersCopy(rule.getTriggers()), RuntimeRule.getRuntimeConditionsCopy(rule.getConditions()), RuntimeRule.getRuntimeActionsCopy(rule.getActions()), rule.getConfigurationDescriptions(), rule.getConfiguration(), rule.getTemplateUID(), rule.getVisibility());
        this.setName(rule.getName());
        this.setTags(rule.getTags());
        this.setDescription(rule.getDescription());
    }

    public Module getModule(String moduleId) {
        if (this.moduleMap == null) {
            this.moduleMap = this.initModuleMap();
        }
        return this.moduleMap.get(moduleId);
    }

    private Map<String, Module> initModuleMap() {
        this.moduleMap = new HashMap<String, Module>(20);
        for (Module m : this.getTriggers()) {
            this.moduleMap.put(m.getId(), m);
        }
        for (Module m : this.getConditions()) {
            this.moduleMap.put(m.getId(), m);
        }
        for (Module m : this.getActions()) {
            this.moduleMap.put(m.getId(), m);
        }
        return this.moduleMap;
    }

    private static List<Action> getRuntimeActionsCopy(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action action : actions) {
                res.add(new RuntimeAction(action));
            }
        }
        return res;
    }

    private static List<Condition> getRuntimeConditionsCopy(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>();
        if (conditions != null) {
            for (Condition condition : conditions) {
                res.add(new RuntimeCondition(condition));
            }
        }
        return res;
    }

    private static List<Trigger> getRuntimeTriggersCopy(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>();
        if (triggers != null) {
            for (Trigger trigger : triggers) {
                res.add(new RuntimeTrigger(trigger));
            }
        }
        return res;
    }
}

