/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.parser.gson.internal.AbstractGSONParser;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;

public class TemplateGSONParser
extends AbstractGSONParser<Template> {
    public Set<Template> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr = new JsonReader((Reader)reader);
        try {
            if (jr.hasNext()) {
                JsonToken token = jr.peek();
                HashSet<Template> templates = new HashSet<Template>();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    templates.addAll((Collection)gson.fromJson(jr, new TypeToken<List<RuleTemplate>>(){}.getType()));
                } else {
                    Template template = (Template)gson.fromJson(jr, RuleTemplate.class);
                    templates.add(template);
                }
                HashSet<Template> hashSet = templates;
                return hashSet;
            }
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(2, null, (Throwable)e));
        }
        finally {
            try {
                jr.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.emptySet();
    }
}

