/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.handler;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.binding.astro.AstroBindingConstants;
import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.calc.SunCalc;
import org.eclipse.smarthome.binding.astro.internal.job.DailyJobSun;
import org.eclipse.smarthome.binding.astro.internal.job.Job;
import org.eclipse.smarthome.binding.astro.internal.model.Planet;
import org.eclipse.smarthome.binding.astro.internal.model.Sun;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

public class SunHandler
extends AstroThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(AstroBindingConstants.THING_TYPE_SUN));
    private final String[] positionalChannelIds = new String[]{"position#azimuth", "position#elevation", "radiation#direct", "radiation#diffuse", "radiation#total"};
    private final SunCalc sunCalc = new SunCalc();
    private Sun sun;

    public SunHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void publishDailyInfo() {
        this.initializeSun();
        this.publishPositionalInfo();
    }

    @Override
    public void publishPositionalInfo() {
        this.initializeSun();
        this.sunCalc.setPositionalInfo(Calendar.getInstance(), this.thingConfig.getLatitude(), this.thingConfig.getLongitude(), this.thingConfig.getAltitude(), this.sun);
        this.publishPlanet();
    }

    @Override
    public Planet getPlanet() {
        return this.sun;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.sun = null;
    }

    @Override
    protected String[] getPositionalChannelIds() {
        return this.positionalChannelIds;
    }

    @Override
    protected Job getDailyJob() {
        return new DailyJobSun(this.thing.getUID().getAsString(), this);
    }

    private void initializeSun() {
        this.sun = this.sunCalc.getSunInfo(Calendar.getInstance(), this.thingConfig.getLatitude(), this.thingConfig.getLongitude(), this.thingConfig.getAltitude());
    }
}

