/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.discovery;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.astro.AstroBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.astro")
public class AstroDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(AstroDiscoveryService.class);
    private static final int DISCOVER_TIMEOUT_SECONDS = 30;
    private static final int LOCATION_CHANGED_CHECK_INTERVAL = 60;
    private LocationProvider locationProvider;
    private ScheduledFuture<?> astroDiscoveryJob;
    private PointType previousLocation;
    private static final ThingUID sunThing = new ThingUID(AstroBindingConstants.THING_TYPE_SUN, "local");
    private static final ThingUID moonThing = new ThingUID(AstroBindingConstants.THING_TYPE_MOON, "local");

    public AstroDiscoveryService() {
        super(new HashSet<ThingTypeUID>(Arrays.asList(new ThingTypeUID("astro", "-"))), 30, true);
    }

    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
    }

    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    protected void startScan() {
        this.logger.debug("Starting Astro discovery scan");
        PointType location = this.locationProvider.getLocation();
        if (location == null) {
            this.logger.debug("LocationProvider.getLocation() is not set -> Will not provide any discovery results");
            return;
        }
        this.createResults(location);
    }

    protected void startBackgroundDiscovery() {
        if (this.astroDiscoveryJob == null) {
            this.astroDiscoveryJob = scheduler.scheduleWithFixedDelay(() -> {
                PointType currentLocation = this.locationProvider.getLocation();
                if (!Objects.equals(currentLocation, this.previousLocation)) {
                    this.logger.debug("Location has been changed from {} to {}: Creating new discovery results", (Object)this.previousLocation, (Object)currentLocation);
                    this.createResults(currentLocation);
                    this.previousLocation = currentLocation;
                }
            }, 0L, 60L, TimeUnit.SECONDS);
            this.logger.debug("Scheduled astro location-changed job every {} seconds", (Object)60);
        }
    }

    protected void stopBackgroundDiscovery() {
        this.logger.debug("Stopping Astro device background discovery");
        if (this.astroDiscoveryJob != null && !this.astroDiscoveryJob.isCancelled() && this.astroDiscoveryJob.cancel(true)) {
            this.astroDiscoveryJob = null;
            this.logger.debug("Stopped Astro device background discovery");
        }
    }

    public void createResults(PointType location) {
        String propGeolocation = location.getAltitude() != null ? String.format("%s,%s,%s", location.getLatitude(), location.getLongitude(), location.getAltitude()) : String.format("%s,%s", location.getLatitude(), location.getLongitude());
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)sunThing).withLabel("Local Sun").withProperty("geolocation", (Object)propGeolocation).withRepresentationProperty("geolocation").build());
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)moonThing).withLabel("Local Moon").withProperty("geolocation", (Object)propGeolocation).withRepresentationProperty("geolocation").build());
    }

    @Reference
    protected void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    protected void unsetLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }
}

