/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import java.util.List;
import org.eclipse.smarthome.binding.astro.internal.job.AbstractJob;
import org.eclipse.smarthome.binding.astro.internal.job.Job;

public final class CompositeJob
extends AbstractJob {
    private final List<Job> jobs;

    public CompositeJob(String thingUID, List<Job> jobs) {
        super(thingUID);
        CompositeJob.checkArgument(jobs != null, "Jobs must not be null");
        CompositeJob.checkArgument(!jobs.isEmpty(), "Jobs must not be empty");
        this.jobs = jobs;
        boolean notMatched = jobs.stream().anyMatch(j -> !j.getThingUID().equals(thingUID));
        CompositeJob.checkArgument(!notMatched, "The jobs must associate the same thing UID");
    }

    @Override
    public void run() {
        this.jobs.forEach(j -> {
            try {
                j.run();
            }
            catch (RuntimeException ex) {
                logger.warn("Job execution failed.", (Throwable)ex);
            }
        });
    }
}

