/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.util;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.smarthome.binding.astro.internal.config.AstroChannelConfig;
import org.eclipse.smarthome.binding.astro.internal.model.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final Pattern HHMM_PATTERN = Pattern.compile("^([0-1][0-9]|2[0-3])(:[0-5][0-9])$");
    public static final double J1970 = 2440588.0;
    public static final double MILLISECONDS_PER_DAY = 8.64E7;

    private DateTimeUtils() {
        throw new IllegalAccessError("Non-instantiable");
    }

    public static Calendar truncateToMidnight(Calendar calendar) {
        return DateUtils.truncate((Calendar)calendar, (int)5);
    }

    public static Range getRange(int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay) {
        Calendar start = Calendar.getInstance();
        start.set(1, startYear);
        start.set(2, startMonth);
        start.set(5, startDay);
        start = DateTimeUtils.truncateToMidnight(start);
        Calendar end = Calendar.getInstance();
        end.set(1, endYear);
        end.set(2, endMonth);
        end.set(5, endDay);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        return new Range(start, end);
    }

    public static Calendar toCalendar(double julianDate) {
        if (Double.compare(julianDate, Double.NaN) == 0 || julianDate == 0.0) {
            return null;
        }
        long millis = (long)((julianDate + 0.5 - 2440588.0) * 8.64E7);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return DateUtils.round((Calendar)cal, (int)12);
    }

    public static double dateToJulianDate(Calendar calendar) {
        return (double)calendar.getTimeInMillis() / 8.64E7 - 0.5 + 2440588.0;
    }

    public static double midnightDateToJulianDate(Calendar calendar) {
        return DateTimeUtils.dateToJulianDate(DateTimeUtils.truncateToMidnight(calendar));
    }

    public static Calendar endOfDayDate(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal = DateUtils.ceiling((Calendar)cal, (int)5);
        cal.add(14, -1);
        return cal;
    }

    public static double endOfDayDateToJulianDate(Calendar calendar) {
        return DateTimeUtils.dateToJulianDate(DateTimeUtils.endOfDayDate(calendar));
    }

    public static double getDecimalYear(Calendar calendar) {
        return (double)calendar.get(1) + (double)calendar.get(6) / (double)calendar.getActualMaximum(6);
    }

    public static Calendar timeToCalendar(Calendar calendar, double time) {
        if (time < 0.0) {
            return null;
        }
        Calendar cal = (Calendar)calendar.clone();
        int hour = 0;
        int minute = 0;
        if (time == 24.0) {
            cal.add(5, 1);
        } else {
            hour = (int)time;
            minute = (int)(time * 100.0 - (double)(hour * 100));
        }
        cal.set(11, hour);
        cal.set(12, minute);
        return DateUtils.truncate((Calendar)cal, (int)12);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1 != null && cal2 != null && DateUtils.isSameDay((Calendar)cal1, (Calendar)cal2);
    }

    public static Date getDate(Calendar calendar) {
        return calendar == null ? null : calendar.getTime();
    }

    public static Calendar getNext(Calendar ... calendars) {
        Calendar now = Calendar.getInstance();
        Calendar next = null;
        Calendar[] calendarArray = calendars;
        int n = calendars.length;
        int n2 = 0;
        while (n2 < n) {
            Calendar calendar = calendarArray[n2];
            if (calendar.after(now) && (next == null || calendar.before(next))) {
                next = calendar;
            }
            ++n2;
        }
        return next;
    }

    public static boolean isTimeGreaterEquals(Calendar cal1, Calendar cal2) {
        Calendar truncCal1 = DateUtils.truncate((Calendar)cal1, (int)12);
        Calendar truncCal2 = DateUtils.truncate((Calendar)cal2, (int)12);
        return truncCal1.getTimeInMillis() >= truncCal2.getTimeInMillis();
    }

    public static Calendar applyConfig(Calendar cal, AstroChannelConfig config) {
        Calendar cEarliest;
        Calendar cCal = cal;
        if (config.getOffset() != null && config.getOffset() != 0) {
            Calendar cOffset = Calendar.getInstance();
            cOffset.setTime(cCal.getTime());
            cOffset.add(12, config.getOffset());
            cCal = cOffset;
        }
        if (cCal.before(cEarliest = DateTimeUtils.adjustTime(cCal, DateTimeUtils.getMinutesFromTime(config.getEarliest())))) {
            return cEarliest;
        }
        Calendar cLatest = DateTimeUtils.adjustTime(cCal, DateTimeUtils.getMinutesFromTime(config.getLatest()));
        if (cCal.after(cLatest)) {
            return cLatest;
        }
        return cCal;
    }

    private static Calendar adjustTime(Calendar cal, int minutes) {
        if (minutes > 0) {
            Calendar cTime = Calendar.getInstance();
            cTime = DateUtils.truncate((Calendar)cal, (int)5);
            cTime.add(12, minutes);
            return cTime;
        }
        return cal;
    }

    private static int getMinutesFromTime(String configTime) {
        String time = StringUtils.trimToNull((String)configTime);
        if (time != null) {
            try {
                if (!HHMM_PATTERN.matcher(time).matches()) {
                    throw new NumberFormatException();
                }
                int hour = Integer.parseInt(StringUtils.substringBefore((String)time, (String)":"));
                int minutes = Integer.parseInt(StringUtils.substringAfter((String)time, (String)":"));
                return hour * 60 + minutes;
            }
            catch (Exception exception) {
                logger.warn("Can not parse astro channel configuration '{}' to hour and minutes, use pattern hh:mm, ignoring!", (Object)time);
            }
        }
        return 0;
    }
}

