/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal.radio;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FrontierSiliconRadioApiResult {
    final Document xmlDoc;
    private final Logger logger = LoggerFactory.getLogger(FrontierSiliconRadioApiResult.class);

    public FrontierSiliconRadioApiResult(String requestResultString) throws IOException {
        Document xml = null;
        try {
            xml = this.getXmlDocFromString(requestResultString);
        }
        catch (Exception e) {
            this.logger.trace("converting to XML failed: '{}' with {}: {}", new Object[]{requestResultString, e.getClass().getName(), e.getMessage()});
            this.logger.debug("converting to XML failed with {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        this.xmlDoc = xml;
    }

    private String getStatus() {
        Element fsApiResult = (Element)this.xmlDoc.getElementsByTagName("fsapiResponse").item(0);
        Element statusNode = (Element)fsApiResult.getElementsByTagName("status").item(0);
        String status = FrontierSiliconRadioApiResult.getCharacterDataFromElement(statusNode);
        this.logger.trace("status is: {}", (Object)status);
        return status;
    }

    public boolean isStatusOk() {
        return "FS_OK".equals(this.getStatus());
    }

    public boolean getValueU8AsBoolean() {
        try {
            Element fsApiResult = (Element)this.xmlDoc.getElementsByTagName("fsapiResponse").item(0);
            Element valueNode = (Element)fsApiResult.getElementsByTagName("value").item(0);
            Element u8Node = (Element)valueNode.getElementsByTagName("u8").item(0);
            String value = FrontierSiliconRadioApiResult.getCharacterDataFromElement(u8Node);
            this.logger.trace("value is: {}", (Object)value);
            return "1".equals(value);
        }
        catch (Exception e) {
            this.logger.error("getting Value.U8 failed with {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return false;
        }
    }

    public int getValueU8AsInt() {
        try {
            Element fsApiResult = (Element)this.xmlDoc.getElementsByTagName("fsapiResponse").item(0);
            Element valueNode = (Element)fsApiResult.getElementsByTagName("value").item(0);
            Element u8Node = (Element)valueNode.getElementsByTagName("u8").item(0);
            String value = FrontierSiliconRadioApiResult.getCharacterDataFromElement(u8Node);
            this.logger.trace("value is: {}", (Object)value);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            this.logger.error("getting Value.U8 failed with {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return 0;
        }
    }

    public int getValueU32AsInt() {
        try {
            Element fsApiResult = (Element)this.xmlDoc.getElementsByTagName("fsapiResponse").item(0);
            Element valueNode = (Element)fsApiResult.getElementsByTagName("value").item(0);
            Element u32Node = (Element)valueNode.getElementsByTagName("u32").item(0);
            String value = FrontierSiliconRadioApiResult.getCharacterDataFromElement(u32Node);
            this.logger.trace("value is: {}", (Object)value);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            this.logger.error("getting Value.U32 failed with {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return 0;
        }
    }

    public String getValueC8ArrayAsString() {
        try {
            Element fsApiResult = (Element)this.xmlDoc.getElementsByTagName("fsapiResponse").item(0);
            Element valueNode = (Element)fsApiResult.getElementsByTagName("value").item(0);
            Element c8Array = (Element)valueNode.getElementsByTagName("c8_array").item(0);
            String value = FrontierSiliconRadioApiResult.getCharacterDataFromElement(c8Array);
            this.logger.trace("value is: {}", (Object)value);
            return value;
        }
        catch (Exception e) {
            this.logger.error("getting Value.c8array failed with {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return "";
        }
    }

    public String getSessionId() {
        NodeList sessionIdTagList = this.xmlDoc.getElementsByTagName("sessionId");
        String givenSessId = FrontierSiliconRadioApiResult.getCharacterDataFromElement((Element)sessionIdTagList.item(0));
        return givenSessId;
    }

    private Document getXmlDocFromString(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlString)));
        return xmlDocument;
    }

    private static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }
}

